/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;

public abstract class TGMeasureHeader {
    public static final int TRIPLET_FEEL_NONE = 1;
    public static final int TRIPLET_FEEL_EIGHTH = 2;
    public static final int TRIPLET_FEEL_SIXTEENTH = 3;
    private int number = 0;
    private long start = 1000L;
    private TGTimeSignature timeSignature;
    private TGTempo tempo;
    private TGMarker marker;
    private boolean repeatOpen;
    private int repeatAlternative;
    private int repeatClose;
    private int tripletFeel;
    private TGSong song;

    public TGMeasureHeader(TGFactory tGFactory) {
        this.timeSignature = tGFactory.newTimeSignature();
        this.tempo = tGFactory.newTempo();
        this.marker = null;
        this.tripletFeel = 1;
        this.repeatOpen = false;
        this.repeatClose = 0;
        this.repeatAlternative = 0;
        this.checkMarker();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
        this.checkMarker();
    }

    public int getRepeatClose() {
        return this.repeatClose;
    }

    public void setRepeatClose(int n) {
        this.repeatClose = n;
    }

    public int getRepeatAlternative() {
        return this.repeatAlternative;
    }

    public void setRepeatAlternative(int n) {
        this.repeatAlternative = n;
    }

    public boolean isRepeatOpen() {
        return this.repeatOpen;
    }

    public void setRepeatOpen(boolean bl) {
        this.repeatOpen = bl;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public int getTripletFeel() {
        return this.tripletFeel;
    }

    public void setTripletFeel(int n) {
        this.tripletFeel = n;
    }

    public TGTempo getTempo() {
        return this.tempo;
    }

    public void setTempo(TGTempo tGTempo) {
        this.tempo = tGTempo;
    }

    public TGTimeSignature getTimeSignature() {
        return this.timeSignature;
    }

    public void setTimeSignature(TGTimeSignature tGTimeSignature) {
        this.timeSignature = tGTimeSignature;
    }

    public TGMarker getMarker() {
        return this.marker;
    }

    public void setMarker(TGMarker tGMarker) {
        this.marker = tGMarker;
    }

    public boolean hasMarker() {
        return this.getMarker() != null;
    }

    private void checkMarker() {
        if (this.hasMarker()) {
            this.marker.setMeasure(this.getNumber());
        }
    }

    public long getLength() {
        return (long)this.getTimeSignature().getNumerator() * this.getTimeSignature().getDenominator().getTime();
    }

    public TGSong getSong() {
        return this.song;
    }

    public void setSong(TGSong tGSong) {
        this.song = tGSong;
    }

    public void makeEqual(TGMeasureHeader tGMeasureHeader) {
        this.start = tGMeasureHeader.getStart();
        this.timeSignature = tGMeasureHeader.getTimeSignature();
        this.tempo = tGMeasureHeader.getTempo();
        this.marker = tGMeasureHeader.getMarker();
        this.repeatOpen = tGMeasureHeader.isRepeatOpen();
        this.repeatClose = tGMeasureHeader.getRepeatClose();
        this.repeatAlternative = tGMeasureHeader.getRepeatAlternative();
        this.checkMarker();
    }

    public TGMeasureHeader clone(TGFactory tGFactory) {
        TGMeasureHeader tGMeasureHeader = tGFactory.newHeader();
        tGMeasureHeader.setNumber(this.getNumber());
        tGMeasureHeader.setStart(this.getStart());
        tGMeasureHeader.setRepeatOpen(this.isRepeatOpen());
        tGMeasureHeader.setRepeatAlternative(this.getRepeatAlternative());
        tGMeasureHeader.setRepeatClose(this.getRepeatClose());
        tGMeasureHeader.setTripletFeel(this.getTripletFeel());
        this.getTimeSignature().copy(tGMeasureHeader.getTimeSignature());
        this.getTempo().copy(tGMeasureHeader.getTempo());
        tGMeasureHeader.setMarker(this.hasMarker() ? this.getMarker().clone(tGFactory) : null);
        return tGMeasureHeader;
    }
}

