/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.filesystem;

import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserData;
import org.herac.tuxguitar.gui.tools.browser.filesystem.TGBrowserDataImpl;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class TGBrowserDataDialog {
    private TGBrowserData data;

    public TGBrowserData getData() {
        return this.data;
    }

    public void setData(TGBrowserData tGBrowserData) {
        this.data = tGBrowserData;
    }

    public TGBrowserData open(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("browser.collection.fs.editor-title"));
        Group group = new Group(shell2, 16);
        group.setLayout(new GridLayout());
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("browser.collection.fs.editor-tip"));
        Composite composite = new Composite(group, 0);
        composite.setLayout(new GridLayout(3, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        Label label = new Label(composite, 16384);
        label.setText(TuxGuitar.getProperty("browser.collection.fs.name"));
        label.setLayoutData(new GridData(16384, 0x1000000, true, true));
        final Text text = new Text(composite, 2048);
        text.setLayoutData(this.getTextData(2));
        Label label2 = new Label(composite, 16384);
        label2.setText(TuxGuitar.getProperty("browser.collection.fs.path"));
        label2.setLayoutData(new GridData(16384, 0x1000000, true, true));
        final Text text2 = new Text(composite, 2048);
        text2.setLayoutData(this.getTextData(1));
        Button button = new Button(composite, 8);
        button.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell2);
                String string = directoryDialog.open();
                if (string != null) {
                    text2.setText(string);
                }
            }
        });
        Composite composite2 = new Composite(shell2, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = text.getText();
                String string2 = text2.getText();
                if (!TGBrowserDataDialog.this.isValidPath(string2)) {
                    MessageDialog.errorMessage(shell2, TuxGuitar.getProperty("browser.collection.fs.invalid-path"));
                    return;
                }
                if (TGBrowserDataDialog.this.isBlank(string)) {
                    string = string2;
                }
                TGBrowserDataDialog.this.setData(new TGBrowserDataImpl(string, string2));
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        DialogUtils.openDialog(shell2, 11);
        return this.getData();
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData getTextData(int n) {
        GridData gridData = new GridData(16384, 0x1000000, true, true, n, 1);
        gridData.minimumWidth = 350;
        return gridData;
    }

    protected boolean isBlank(String string) {
        return string == null || string.length() == 0;
    }

    protected boolean isValidPath(String string) {
        if (!this.isBlank(string)) {
            File file = new File(string);
            return file.exists() && file.isDirectory();
        }
        return false;
    }
}

