/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.keybindings;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingActionDefaults;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingReserveds;
import org.herac.tuxguitar.gui.system.keybindings.xml.KeyBindingReader;
import org.herac.tuxguitar.gui.system.keybindings.xml.KeyBindingWriter;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class KeyBindingActionManager {
    private List keyBindingsActions = new ArrayList();
    private KeyBindingListener listener;

    public KeyBindingActionManager() {
        this.init();
    }

    public void init() {
        List list = KeyBindingReader.getKeyBindings(this.getUserFileName());
        this.keyBindingsActions.addAll(list != null ? list : KeyBindingActionDefaults.getDefaultKeyBindings());
        this.listener = new KeyBindingListener();
    }

    private String getUserFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "keybindings.xml";
    }

    public Action getActionForKeyBinding(KeyBinding keyBinding) {
        Action action = KeyBindingReserveds.getActionForKeyBinding(keyBinding);
        if (action != null) {
            return action;
        }
        Iterator iterator = this.keyBindingsActions.iterator();
        while (iterator.hasNext()) {
            KeyBindingAction keyBindingAction = (KeyBindingAction)iterator.next();
            if (!keyBinding.equals(keyBindingAction.getKeyBinding())) continue;
            return TuxGuitar.instance().getAction(keyBindingAction.getAction());
        }
        return null;
    }

    public KeyBinding getKeyBindingForAction(String string) {
        KeyBinding keyBinding = KeyBindingReserveds.getKeyBindingForAction(string);
        if (keyBinding != null) {
            return keyBinding;
        }
        Iterator iterator = this.keyBindingsActions.iterator();
        while (iterator.hasNext()) {
            KeyBindingAction keyBindingAction = (KeyBindingAction)iterator.next();
            if (!string.equals(keyBindingAction.getAction())) continue;
            return keyBindingAction.getKeyBinding();
        }
        return null;
    }

    public void reset(List list) {
        this.keyBindingsActions.clear();
        this.keyBindingsActions.addAll(list);
    }

    public List getKeyBindingActions() {
        return this.keyBindingsActions;
    }

    public void saveKeyBindings() {
        KeyBindingWriter.setBindings(this.getKeyBindingActions(), this.getUserFileName());
    }

    public void appendListenersTo(Control control) {
        control.addKeyListener(this.listener);
    }

    protected class KeyBindingListener
    implements KeyListener {
        protected KeyBindingListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            KeyBinding keyBinding = new KeyBinding();
            keyBinding.setKey(keyEvent.keyCode);
            keyBinding.setMask(keyEvent.stateMask);
            Action action = KeyBindingActionManager.this.getActionForKeyBinding(keyBinding);
            if (action != null) {
                action.process(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

