/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.system.config.TGConfigEditor;
import org.herac.tuxguitar.gui.system.config.items.Option;

public class LanguageOption
extends Option {
    protected boolean initialized = false;
    protected Button[] buttons;
    protected String[] languages;
    protected String language;
    protected String selected;

    public LanguageOption(TGConfigEditor tGConfigEditor, ToolBar toolBar, Composite composite) {
        super(tGConfigEditor, toolBar, composite, TuxGuitar.getProperty("settings.config.language"));
    }

    public void createOption() {
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
        this.getToolItem().setImage(TuxGuitar.instance().getIconManager().getOptionLanguage());
        this.getToolItem().addSelectionListener(this);
        this.showLabel(this.getComposite(), 4, 0x1000000, 16576, 1, 0, TuxGuitar.getProperty("settings.config.language.choose"));
        Composite composite = new Composite(this.getComposite(), 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(this.getTabbedData());
        this.languages = TuxGuitar.instance().getLanguageManager().getLanguages();
        if (this.languages != null) {
            this.buttons = new Button[this.languages.length];
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i] = new Button(composite, 16);
                this.buttons[i].setData(this.languages[i]);
                this.buttons[i].setText(TuxGuitar.getProperty("locale." + this.languages[i]));
            }
        }
        this.loadConfig();
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            public void run() {
                LanguageOption.this.language = LanguageOption.this.getConfig().getStringConfigValue("language");
                if (LanguageOption.this.language == null || LanguageOption.this.language.trim().length() == 0) {
                    LanguageOption.this.language = TuxGuitar.instance().getLanguageManager().getLanguage();
                }
                if (LanguageOption.this.languages != null) {
                    for (int i = 0; i < LanguageOption.this.languages.length; ++i) {
                        if (!LanguageOption.this.languages[i].equals(LanguageOption.this.language)) continue;
                        final int n = i;
                        new SyncThread(new Runnable(){

                            public void run() {
                                if (!LanguageOption.this.isDisposed()) {
                                    (this).LanguageOption.this.buttons[n].setSelection(true);
                                    (this).LanguageOption.this.initialized = true;
                                    LanguageOption.this.pack();
                                }
                            }
                        }).start();
                        return;
                    }
                    LanguageOption.this.initialized = true;
                    new SyncThread(new Runnable(){

                        public void run() {
                            LanguageOption.this.pack();
                        }
                    }).start();
                }
            }
        }).start();
    }

    public void updateConfig() {
        if (this.initialized) {
            if (this.buttons != null && this.buttons.length > 0) {
                for (int i = 0; i < this.buttons.length; ++i) {
                    if (!this.buttons[i].getSelection()) continue;
                    this.selected = (String)this.buttons[i].getData();
                }
            }
            if (this.selected != null && !this.selected.equals(this.language)) {
                this.getConfig().setProperty("language", this.selected);
            }
        }
    }

    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setProperty("language", this.getDefaults().getProperty("language"));
        }
    }

    public void applyConfig(boolean bl) {
        if (bl || this.initialized) {
            boolean bl2 = bl;
            if (!(bl2 || this.selected == null || this.language != null && this.selected.equals(this.language))) {
                bl2 = true;
            }
            if (bl2) {
                this.addSyncThread(new Runnable(){

                    public void run() {
                        TuxGuitar.instance().loadLanguage();
                    }
                });
            }
        }
    }
}

