/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.system.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.herac.tuxguitar.gui.system.config.TGConfigDefaults;

public abstract class TGConfigManager {
    private Properties properties;

    public void init() {
        this.properties = new Properties(this.getDefaults());
        this.load();
    }

    private String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public String getStringConfigValue(String string, String string2) {
        try {
            String string3 = this.getProperty(string);
            return string3 == null ? string2 : string3.trim();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return string2;
        }
    }

    public String getStringConfigValue(String string) {
        return this.getStringConfigValue(string, null);
    }

    public int getIntConfigValue(String string, int n) {
        try {
            String string2 = this.getProperty(string);
            return string2 == null ? n : Integer.parseInt(string2.trim());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return n;
        }
    }

    public int getIntConfigValue(String string) {
        return this.getIntConfigValue(string, 0);
    }

    public boolean getBooleanConfigValue(String string, boolean bl) {
        try {
            String string2 = this.getProperty(string);
            return string2 == null ? bl : Boolean.valueOf(string2.trim());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return bl;
        }
    }

    public boolean getBooleanConfigValue(String string) {
        return this.getBooleanConfigValue(string, false);
    }

    public FontData getFontDataConfigValue(String string) {
        try {
            String[] stringArray;
            String string2 = this.getProperty(string);
            if (string2 != null && (stringArray = string2.trim().split(",")) != null && stringArray.length == 3) {
                try {
                    String string3 = stringArray[0].trim();
                    int n = Integer.parseInt(stringArray[1].trim());
                    int n2 = Integer.parseInt(stringArray[2].trim());
                    return new FontData(string3 == null ? "" : string3, n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return new FontData();
    }

    public RGB getRGBConfigValue(String string) {
        try {
            String[] stringArray;
            String string2 = this.getProperty(string);
            if (string2 != null && (stringArray = string2.trim().split(",")) != null && stringArray.length == 3) {
                try {
                    int n = Integer.parseInt(stringArray[0].trim());
                    int n2 = Integer.parseInt(stringArray[1].trim());
                    int n3 = Integer.parseInt(stringArray[2].trim());
                    return new RGB(n, n2, n3);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2 != null ? string2 : new String());
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    public void setProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    public void setProperty(String string, RGB rGB) {
        this.setProperty(string, rGB.red + "," + rGB.green + "," + rGB.blue);
    }

    public void setProperty(String string, FontData fontData) {
        this.setProperty(string, fontData.getName() + "," + fontData.getHeight() + "," + fontData.getStyle());
    }

    public void setDefaults() {
        Properties properties = new TGConfigDefaults().getProperties();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            this.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        this.save();
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void clear() {
        this.properties.clear();
    }

    public void load() {
        try {
            if (new File(this.getFileName()).exists()) {
                FileInputStream fileInputStream = new FileInputStream(this.getFileName());
                this.properties.clear();
                this.properties.load(fileInputStream);
            } else {
                this.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            File file;
            File file2 = new File(this.getFileName());
            if (!file2.exists() && (file = file2.getParentFile()) != null && !file.exists()) {
                file.mkdirs();
            }
            this.properties.store(new FileOutputStream(file2), this.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public abstract String getName();

    public abstract String getFileName();

    public abstract Properties getDefaults();
}

