/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.base.TGSongImporter;

public class FileMenuItem
implements MenuItems {
    private MenuItem fileMenuItem;
    private Menu menu;
    private Menu importMenu;
    private Menu exportMenu;
    private Menu historyMenu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem openURL;
    private MenuItem save;
    private MenuItem saveAs;
    private MenuItem importItem;
    private MenuItem exportItem;
    private MenuItem printPreview;
    private MenuItem print;
    private MenuItem historyItem;
    private MenuItem[] historyFiles;
    private MenuItem exit;

    public FileMenuItem(Shell shell, Menu menu, int n) {
        this.fileMenuItem = new MenuItem(menu, n);
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        Object object;
        Object object2;
        this.newSong = new MenuItem(this.menu, 8);
        this.newSong.addSelectionListener(TuxGuitar.instance().getAction("action.file.new"));
        this.open = new MenuItem(this.menu, 8);
        this.open.addSelectionListener(TuxGuitar.instance().getAction("action.file.open"));
        this.openURL = new MenuItem(this.menu, 8);
        this.openURL.addSelectionListener(TuxGuitar.instance().getAction("action.file.open-url"));
        new MenuItem(this.menu, 2);
        this.save = new MenuItem(this.menu, 8);
        this.save.addSelectionListener(TuxGuitar.instance().getAction("action.file.save"));
        this.saveAs = new MenuItem(this.menu, 8);
        this.saveAs.addSelectionListener(TuxGuitar.instance().getAction("action.file.save-as"));
        new MenuItem(this.menu, 2);
        this.importItem = new MenuItem(this.menu, 64);
        this.importMenu = new Menu(this.menu.getShell(), 4);
        Iterator iterator = TGFileFormatManager.instance().getImporters();
        while (iterator.hasNext()) {
            object2 = (TGSongImporter)iterator.next();
            object = new MenuItem(this.importMenu, 8);
            ((Widget)object).setData(object2);
            ((MenuItem)object).addSelectionListener(TuxGuitar.instance().getAction("action.file.import"));
            ((MenuItem)object).setText(TuxGuitar.getProperty("file.import") + " " + object2.getImportName());
        }
        this.exportItem = new MenuItem(this.menu, 64);
        this.exportMenu = new Menu(this.menu.getShell(), 4);
        object2 = TGFileFormatManager.instance().getExporters();
        while (object2.hasNext()) {
            object = (TGSongExporter)object2.next();
            MenuItem menuItem = new MenuItem(this.exportMenu, 8);
            menuItem.setData(object);
            menuItem.addSelectionListener(TuxGuitar.instance().getAction("action.file.export"));
            menuItem.setText(TuxGuitar.getProperty("file.export") + " " + object.getExportName());
        }
        new MenuItem(this.menu, 2);
        this.printPreview = new MenuItem(this.menu, 8);
        this.printPreview.addSelectionListener(TuxGuitar.instance().getAction("action.file.print-preview"));
        this.print = new MenuItem(this.menu, 8);
        this.print.addSelectionListener(TuxGuitar.instance().getAction("action.file.print"));
        new MenuItem(this.menu, 2);
        this.historyItem = new MenuItem(this.menu, 64);
        this.historyMenu = new Menu(this.menu.getShell(), 4);
        this.updateHistoryFiles();
        new MenuItem(this.menu, 2);
        this.exit = new MenuItem(this.menu, 8);
        this.exit.addSelectionListener(TuxGuitar.instance().getAction("action.file.exit"));
        this.importItem.setMenu(this.importMenu);
        this.exportItem.setMenu(this.exportMenu);
        this.historyItem.setMenu(this.historyMenu);
        this.fileMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List list = TuxGuitar.instance().getFileHistory().getURLs();
        this.historyFiles = new MenuItem[list.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            URL uRL = (URL)list.get(i);
            this.historyFiles[i] = new MenuItem(this.historyMenu, 8);
            this.historyFiles[i].setText(this.decode(uRL.toString()));
            this.historyFiles[i].setData(uRL);
            this.historyFiles[i].addSelectionListener(TuxGuitar.instance().getAction("action.file.open"));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public void update() {
        if (TuxGuitar.instance().getFileHistory().isChanged()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            TuxGuitar.instance().getFileHistory().setChanged(false);
        }
    }

    public void loadProperties() {
        this.fileMenuItem.setText(TuxGuitar.getProperty("file"));
        this.newSong.setText(TuxGuitar.getProperty("file.new"));
        this.open.setText(TuxGuitar.getProperty("file.open"));
        this.openURL.setText(TuxGuitar.getProperty("file.open-url"));
        this.save.setText(TuxGuitar.getProperty("file.save"));
        this.saveAs.setText(TuxGuitar.getProperty("file.save-as"));
        this.importItem.setText(TuxGuitar.getProperty("file.import"));
        this.exportItem.setText(TuxGuitar.getProperty("file.export"));
        this.printPreview.setText(TuxGuitar.getProperty("file.print-preview"));
        this.print.setText(TuxGuitar.getProperty("file.print"));
        this.historyItem.setText(TuxGuitar.getProperty("file.history"));
        this.exit.setText(TuxGuitar.getProperty("file.exit"));
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.instance().getIconManager().getFileNew());
        this.open.setImage(TuxGuitar.instance().getIconManager().getFileOpen());
        this.save.setImage(TuxGuitar.instance().getIconManager().getFileSave());
        this.saveAs.setImage(TuxGuitar.instance().getIconManager().getFileSaveAs());
        this.printPreview.setImage(TuxGuitar.instance().getIconManager().getFilePrintPreview());
        this.print.setImage(TuxGuitar.instance().getIconManager().getFilePrint());
    }
}

