/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;

public class DurationMenuItem
implements MenuItems {
    private MenuItem durationMenuItem;
    private Menu menu;
    private MenuItem whole;
    private MenuItem half;
    private MenuItem quarter;
    private MenuItem eighth;
    private MenuItem sixteenth;
    private MenuItem thirtySecond;
    private MenuItem sixtyFourth;
    private MenuItem dotted;
    private MenuItem doubleDotted;
    private MenuItem tupleto;

    public DurationMenuItem(Shell shell, Menu menu, int n) {
        this.durationMenuItem = new MenuItem(menu, n);
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.whole = new MenuItem(this.menu, 8);
        this.whole.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-whole"));
        this.half = new MenuItem(this.menu, 8);
        this.half.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-half"));
        this.quarter = new MenuItem(this.menu, 8);
        this.quarter.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-quarter"));
        this.eighth = new MenuItem(this.menu, 8);
        this.eighth.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-eighth"));
        this.sixteenth = new MenuItem(this.menu, 8);
        this.sixteenth.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-sixteenth"));
        this.thirtySecond = new MenuItem(this.menu, 8);
        this.thirtySecond.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-thirty-second"));
        this.sixtyFourth = new MenuItem(this.menu, 8);
        this.sixtyFourth.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.set-sixty-fourth"));
        new MenuItem(this.menu, 2);
        this.dotted = new MenuItem(this.menu, 8);
        this.dotted.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.change-dotted"));
        this.doubleDotted = new MenuItem(this.menu, 8);
        this.doubleDotted.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.change-double-dotted"));
        this.tupleto = new MenuItem(this.menu, 8);
        this.tupleto.addSelectionListener(TuxGuitar.instance().getAction("action.note.duration.change-tupleto"));
        this.durationMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.whole.setEnabled(!bl);
        this.half.setEnabled(!bl);
        this.quarter.setEnabled(!bl);
        this.eighth.setEnabled(!bl);
        this.sixteenth.setEnabled(!bl);
        this.thirtySecond.setEnabled(!bl);
        this.sixtyFourth.setEnabled(!bl);
        this.dotted.setEnabled(!bl);
        this.doubleDotted.setEnabled(!bl);
        this.tupleto.setEnabled(!bl);
    }

    public void loadProperties() {
        this.durationMenuItem.setText(TuxGuitar.getProperty("duration"));
        this.whole.setText(TuxGuitar.getProperty("duration.whole"));
        this.half.setText(TuxGuitar.getProperty("duration.half"));
        this.quarter.setText(TuxGuitar.getProperty("duration.quarter"));
        this.eighth.setText(TuxGuitar.getProperty("duration.eighth"));
        this.sixteenth.setText(TuxGuitar.getProperty("duration.sixteenth"));
        this.thirtySecond.setText(TuxGuitar.getProperty("duration.thirtysecond"));
        this.sixtyFourth.setText(TuxGuitar.getProperty("duration.sixtyfourth"));
        this.dotted.setText(TuxGuitar.getProperty("duration.dotted"));
        this.doubleDotted.setText(TuxGuitar.getProperty("duration.doubledotted"));
        this.tupleto.setText(TuxGuitar.getProperty("duration.tupleto"));
    }

    public void loadIcons() {
        this.whole.setImage(TuxGuitar.instance().getIconManager().getDuration(1));
        this.half.setImage(TuxGuitar.instance().getIconManager().getDuration(2));
        this.quarter.setImage(TuxGuitar.instance().getIconManager().getDuration(4));
        this.eighth.setImage(TuxGuitar.instance().getIconManager().getDuration(8));
        this.sixteenth.setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.thirtySecond.setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.sixtyFourth.setImage(TuxGuitar.instance().getIconManager().getDuration(64));
        this.dotted.setImage(TuxGuitar.instance().getIconManager().getDurationDotted());
        this.doubleDotted.setImage(TuxGuitar.instance().getIconManager().getDurationDoubleDotted());
        this.tupleto.setImage(TuxGuitar.instance().getIconManager().getDurationTupleto());
    }
}

