/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.gui.items.menu.ChordMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.DynamicMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteEffectsMenuItem;
import org.herac.tuxguitar.song.models.TGNote;

public class BeatMenuItem
implements MenuItems {
    private MenuItem noteMenuItem;
    private Menu menu;
    private MenuItem tiedNote;
    private MenuItem cleanBeat;
    private MenuItem insertText;
    private MenuItem shiftUp;
    private MenuItem shiftDown;
    private MenuItem semitoneUp;
    private MenuItem semitoneDown;
    private DurationMenuItem durationMenuItem;
    private ChordMenuItem chordMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private DynamicMenuItem dynamicMenuItem;

    public BeatMenuItem(Shell shell, Menu menu, int n) {
        this.noteMenuItem = new MenuItem(menu, n);
        this.menu = new Menu(shell, 4);
    }

    public void showItems() {
        this.tiedNote = new MenuItem(this.menu, 8);
        this.tiedNote.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.tied"));
        this.cleanBeat = new MenuItem(this.menu, 8);
        this.cleanBeat.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.clean-beat"));
        this.durationMenuItem = new DurationMenuItem(this.menu.getShell(), this.menu, 64);
        this.durationMenuItem.showItems();
        this.chordMenuItem = new ChordMenuItem(this.menu.getShell(), this.menu, 64);
        this.chordMenuItem.showItems();
        this.effectMenuItem = new NoteEffectsMenuItem(this.menu.getShell(), this.menu, 64);
        this.effectMenuItem.showItems();
        this.dynamicMenuItem = new DynamicMenuItem(this.menu.getShell(), this.menu, 64);
        this.dynamicMenuItem.showItems();
        new MenuItem(this.menu, 2);
        this.insertText = new MenuItem(this.menu, 8);
        this.insertText.addSelectionListener(TuxGuitar.instance().getAction("action.insert.text"));
        new MenuItem(this.menu, 2);
        this.semitoneUp = new MenuItem(this.menu, 8);
        this.semitoneUp.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.increment-semitone"));
        this.semitoneDown = new MenuItem(this.menu, 8);
        this.semitoneDown.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.decrement-semitone"));
        new MenuItem(this.menu, 2);
        this.shiftUp = new MenuItem(this.menu, 8);
        this.shiftUp.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.shift-up"));
        this.shiftDown = new MenuItem(this.menu, 8);
        this.shiftDown.addSelectionListener(TuxGuitar.instance().getAction("action.note.general.shift-down"));
        this.noteMenuItem.setMenu(this.menu);
        this.loadIcons();
        this.loadProperties();
    }

    public void update() {
        TGNote tGNote = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        boolean bl = TuxGuitar.instance().getPlayer().isRunning();
        this.tiedNote.setEnabled(!bl);
        this.cleanBeat.setEnabled(!bl);
        this.semitoneUp.setEnabled(!bl && tGNote != null);
        this.semitoneDown.setEnabled(!bl && tGNote != null);
        this.shiftUp.setEnabled(!bl && tGNote != null);
        this.shiftDown.setEnabled(!bl && tGNote != null);
        this.insertText.setEnabled(!bl);
        this.durationMenuItem.update();
        this.chordMenuItem.update();
        this.effectMenuItem.update();
        this.dynamicMenuItem.update();
    }

    public void loadProperties() {
        this.noteMenuItem.setText(TuxGuitar.getProperty("beat"));
        this.cleanBeat.setText(TuxGuitar.getProperty("beat.clean"));
        this.tiedNote.setText(TuxGuitar.getProperty("note.tiednote"));
        this.semitoneUp.setText(TuxGuitar.getProperty("note.semitone-up"));
        this.semitoneDown.setText(TuxGuitar.getProperty("note.semitone-down"));
        this.shiftUp.setText(TuxGuitar.getProperty("note.shift-up"));
        this.shiftDown.setText(TuxGuitar.getProperty("note.shift-down"));
        this.insertText.setText(TuxGuitar.getProperty("text.insert"));
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }

    public void loadIcons() {
        this.tiedNote.setImage(TuxGuitar.instance().getIconManager().getNoteTied());
    }
}

