/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.help.doc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.help.doc.DocItem;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocItemReader {
    private static final String ITEM_TAG = "item";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_URL = "url";

    public void loadHelpItems(List list, File file) {
        if (file != null && file.exists()) {
            try {
                Document document = this.getDocument(file);
                this.loadHelpItems(list, document.getFirstChild());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void loadHelpItems(List list, Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (!string.equals(ITEM_TAG)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            DocItem docItem = new DocItem(this.getAttribute(ATTRIBUTE_NAME, namedNodeMap), this.getAttribute(ATTRIBUTE_URL, namedNodeMap));
            this.loadHelpItems(docItem.getChildren(), node2);
            list.add(docItem);
        }
    }

    private String getAttribute(String string, NamedNodeMap namedNodeMap) {
        Node node = namedNodeMap.getNamedItem(string);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(file);
        return document;
    }
}

