/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.help.about;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.help.about.AboutContentReader;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class AboutDialog {
    private static final String RELEASE_NAME = "TuxGuitar 1.0-rc1";
    private static final String PROPERTY_PREFIX = "help.about.";
    private static final int IMAGE_WIDTH = 100;
    private static final int IMAGE_HEIGHT = 100;
    private static final int TAB_ITEM_WIDTH = 640;
    private static final int TAB_ITEM_HEIGHT = 300;
    protected Composite imageComposite;
    protected Image image;

    public void open(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("help.about"));
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.image = TuxGuitar.instance().getIconManager().getAboutDescription();
        this.imageComposite = new Composite(composite, 0);
        this.imageComposite.setLayoutData(new GridData(100, 100));
        this.imageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = AboutDialog.this.image.getBounds();
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.drawImage(AboutDialog.this.image, (100 - rectangle.width) / 2, (100 - rectangle.height) / 2);
                tGPainter.dispose();
            }
        });
        final Font font = new Font((Device)shell2.getDisplay(), TuxGuitar.instance().getConfig().getFontDataConfigValue("font.about.dialog.title"));
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(4, 0x1000000, true, true));
        label.setFont(font);
        label.setForeground(shell2.getDisplay().getSystemColor(15));
        label.setText(RELEASE_NAME);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                font.dispose();
            }
        });
        Composite composite2 = new Composite(shell2, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(4, 4, true, true));
        final TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayoutData(new GridData(4, 4, true, true));
        tabFolder.setLayout(new FormLayout());
        AboutContentReader aboutContentReader = new AboutContentReader();
        this.makeTabItem(tabFolder, "description", aboutContentReader.read("description").toString());
        this.makeTabItem(tabFolder, "authors", aboutContentReader.read("authors").toString());
        this.makeTabItem(tabFolder, "license", aboutContentReader.read("license").toString());
        tabFolder.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (tabFolder.getSelectionIndex() == 0) {
                    AboutDialog.this.image = TuxGuitar.instance().getIconManager().getAboutDescription();
                } else if (tabFolder.getSelectionIndex() == 1) {
                    AboutDialog.this.image = TuxGuitar.instance().getIconManager().getAboutAuthors();
                } else if (tabFolder.getSelectionIndex() == 2) {
                    AboutDialog.this.image = TuxGuitar.instance().getIconManager().getAboutLicense();
                }
                AboutDialog.this.imageComposite.redraw();
            }
        });
        Composite composite3 = new Composite(shell2, 0);
        composite3.setLayout(new GridLayout());
        composite3.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite3, 8);
        button.setLayoutData(this.getButtonData());
        button.setText(TuxGuitar.getProperty("exit"));
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        tabFolder.setSelection(0);
        DialogUtils.openDialog(shell2, 3);
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void makeTabItem(TabFolder tabFolder, String string, String string2) {
        Composite composite = new Composite(tabFolder, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new FormData(640, 300));
        Text text = new Text(composite, 2626);
        text.setLayoutData(new GridData(4, 4, true, true));
        text.setBackground(TuxGuitar.instance().getDisplay().getSystemColor(1));
        text.setEditable(false);
        text.append(string2);
        text.setSelection(0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(TuxGuitar.getProperty(PROPERTY_PREFIX + string));
        tabItem.setControl(composite);
    }
}

