/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.editors.tab.painters.TGNotePainter;
import org.herac.tuxguitar.gui.util.ImageUtils;

public class TGResources {
    private static final int SCORE_NOTE_EMPTY_NORMAL_MODE = 0;
    private static final int SCORE_NOTE_EMPTY_PLAY_MODE = 1;
    private static final int SCORE_NOTE_FULL_NORMAL_MODE = 2;
    private static final int SCORE_NOTE_FULL_PLAY_MODE = 3;
    private ViewLayout layout;
    private List resources;
    private Font defaultFont;
    private Font noteFont;
    private Font timeSignatureFont;
    private Font lyricFont;
    private Font textFont;
    private Font graceFont;
    private Font chordFont;
    private Font chordFretFont;
    private Font printerDefaultFont;
    private Font printerNoteFont;
    private Font printerTimeSignatureFont;
    private Font printerLyricFont;
    private Font printerTextFont;
    private Font printerGraceFont;
    private Font printerChordFont;
    private Color backgroundColor;
    private Color lineColor;
    private Color scoreNoteColor;
    private Color tabNoteColor;
    private Color playNoteColor;
    private Image[] scoreNotes;
    private Image[] harmonicNotes;
    private Image tempoImage;
    private Image tripletFeel8;
    private Image tripletFeelNone8;
    private Image tripletFeel16;
    private Image tripletFeelNone16;
    private int scoreNoteWidth;

    public TGResources(ViewLayout viewLayout) {
        this.layout = viewLayout;
        this.resources = new ArrayList();
    }

    public void load() {
        this.dispose();
        this.initFonts();
        this.initColors();
        this.initImages();
    }

    public ViewLayout getLayout() {
        return this.layout;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public Font getNoteFont() {
        return this.noteFont;
    }

    public Font getTimeSignatureFont() {
        return this.timeSignatureFont;
    }

    public Font getLyricFont() {
        return this.lyricFont;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public Font getChordFont() {
        return this.chordFont;
    }

    public Font getChordFretFont() {
        return this.chordFretFont;
    }

    public Font getGraceFont() {
        return this.graceFont;
    }

    public Font getPrinterDefaultFont() {
        return this.printerDefaultFont;
    }

    public Font getPrinterNoteFont() {
        return this.printerNoteFont;
    }

    public Font getPrinterTimeSignatureFont() {
        return this.printerTimeSignatureFont;
    }

    public Font getPrinterLyricFont() {
        return this.printerLyricFont;
    }

    public Font getPrinterTextFont() {
        return this.printerTextFont;
    }

    public Font getPrinterGraceFont() {
        return this.printerGraceFont;
    }

    public Font getPrinterChordFont() {
        return this.printerChordFont;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getPlayNoteColor() {
        return this.playNoteColor;
    }

    public Color getScoreNoteColor() {
        return this.scoreNoteColor;
    }

    public Color getTabNoteColor() {
        return this.tabNoteColor;
    }

    public Image getTempoImage() {
        return this.tempoImage;
    }

    public Image getTripletFeel8() {
        return this.tripletFeel8;
    }

    public Image getTripletFeelNone8() {
        return this.tripletFeelNone8;
    }

    public Image getTripletFeel16() {
        return this.tripletFeel16;
    }

    public Image getTripletFeelNone16() {
        return this.tripletFeelNone16;
    }

    public Image getScoreNote(int n, boolean bl) {
        int n2 = 0;
        n2 += bl ? 1 : 0;
        return this.scoreNotes[n2 += n >= 4 ? 2 : 0];
    }

    public Image getHarmonicNote(int n, boolean bl) {
        int n2 = 0;
        n2 += bl ? 1 : 0;
        return this.harmonicNotes[n2 += n >= 4 ? 2 : 0];
    }

    public int getScoreNoteWidth() {
        return this.scoreNoteWidth;
    }

    private void initFonts() {
        float f = this.layout.getFontScale();
        this.defaultFont = this.getFont("font.default", f);
        this.noteFont = this.getFont("font.note", f);
        this.timeSignatureFont = this.getFont("font.time-signature", f);
        this.lyricFont = this.getFont("font.lyric", f);
        this.textFont = this.getFont("font.text", f);
        this.graceFont = this.getFont("font.grace", f);
        this.chordFont = this.getFont("font.chord", f);
        this.chordFretFont = this.getFont("font.chord-fret", f);
        this.printerDefaultFont = this.getFont("font.printer.default", f);
        this.printerNoteFont = this.getFont("font.printer.note", f);
        this.printerTimeSignatureFont = this.getFont("font.printer.time-signature", f);
        this.printerLyricFont = this.getFont("font.printer.lyric", f);
        this.printerTextFont = this.getFont("font.printer.text", f);
        this.printerGraceFont = this.getFont("font.printer.grace", f);
        this.printerChordFont = this.getFont("font.printer.chord", f);
    }

    private void initColors() {
        this.backgroundColor = this.getColor("color.background");
        this.lineColor = this.getColor("color.line");
        this.scoreNoteColor = this.getColor("color.score.note");
        this.tabNoteColor = this.getColor("color.tab.note");
        this.playNoteColor = this.getColor("color.play.note");
    }

    private void initImages() {
        this.scoreNotes = new Image[4];
        this.scoreNotes[0] = this.getScoreNoteImage(this.getScoreNoteColor(), false);
        this.scoreNotes[1] = this.getScoreNoteImage(this.getPlayNoteColor(), false);
        this.scoreNotes[2] = this.getScoreNoteImage(this.getScoreNoteColor(), true);
        this.scoreNotes[3] = this.getScoreNoteImage(this.getPlayNoteColor(), true);
        this.harmonicNotes = new Image[4];
        this.harmonicNotes[0] = this.getArmonicImage(this.getScoreNoteColor(), false);
        this.harmonicNotes[1] = this.getArmonicImage(this.getPlayNoteColor(), false);
        this.harmonicNotes[2] = this.getArmonicImage(this.getScoreNoteColor(), true);
        this.harmonicNotes[3] = this.getArmonicImage(this.getPlayNoteColor(), true);
        this.tempoImage = this.getTempoImage(TuxGuitar.instance().getDisplay().getSystemColor(2));
        this.tripletFeel8 = this.getTripletFeel8(TuxGuitar.instance().getDisplay().getSystemColor(2));
        this.tripletFeelNone8 = this.getTripletFeelNone8(TuxGuitar.instance().getDisplay().getSystemColor(2));
        this.tripletFeel16 = this.getTripletFeel16(TuxGuitar.instance().getDisplay().getSystemColor(2));
        this.tripletFeelNone16 = this.getTripletFeelNone16(TuxGuitar.instance().getDisplay().getSystemColor(2));
    }

    private Font getFont(String string, float f) {
        float f2;
        FontData fontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(string);
        if (fontData == null) {
            fontData = new FontData();
        }
        fontData.setHeight((f2 = (float)fontData.getHeight() * f) > 1.0f ? Math.round(f2) : 1);
        Font font = new Font((Device)TuxGuitar.instance().getDisplay(), fontData);
        this.resources.add(font);
        return font;
    }

    private Color getColor(String string) {
        RGB rGB = TuxGuitar.instance().getConfig().getRGBConfigValue(string);
        if (rGB == null) {
            rGB = new RGB(0, 0, 0);
        }
        Color color = new Color(TuxGuitar.instance().getDisplay(), rGB);
        this.resources.add(color);
        return color;
    }

    private Image getScoreNoteImage(Color color, boolean bl) {
        float f = (bl ? this.getLayout().getScoreLineSpacing() + 1 : this.getLayout().getScoreLineSpacing()) - 2;
        int n = Math.round(f * 1.33f);
        int n2 = Math.round(f * 1.0f);
        Image image = this.getImage(n + 1, n2 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(color);
        tGPainter.setForeground(color);
        tGPainter.initPath(bl ? 2 : 1);
        TGNotePainter.paintNote(tGPainter, 0.0f, 1.0f, f);
        tGPainter.closePath();
        tGPainter.dispose();
        this.scoreNoteWidth = n;
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getArmonicImage(Color color, boolean bl) {
        int n = this.getLayout().getScoreLineSpacing();
        int n2 = 0;
        int n3 = 1;
        int n4 = this.getScoreNoteWidth() - 1;
        int n5 = n - 2;
        Image image = this.getImage(n2 + n4 + 2, n3 + n5 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setForeground(color);
        tGPainter.setBackground(color);
        tGPainter.initPath(bl ? 3 : 1);
        tGPainter.moveTo(n2, n3 + n5 / 2);
        tGPainter.lineTo(n2 + n4 / 2, n3 + n5);
        tGPainter.lineTo(n2 + n4, n3 + n5 / 2);
        tGPainter.lineTo(n2 + n4 / 2, n3);
        tGPainter.lineTo(n2, n3 + n5 / 2);
        tGPainter.closePath();
        tGPainter.dispose();
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getTempoImage(Color color) {
        float f = 5.0f * this.getLayout().getScale();
        int n = Math.round(f * 1.33f);
        int n2 = Math.round(f * 3.5f);
        Image image = this.getImage(n + 1, n2 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(color);
        tGPainter.setForeground(color);
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, (float)n - f * 1.33f, (float)n2 - 1.0f * f, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(n, 0.0f);
        tGPainter.lineTo(n, (float)n2 - 0.66f * f);
        tGPainter.closePath();
        tGPainter.dispose();
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getTripletFeelNone8(Color color) {
        float f = 5.0f * this.getLayout().getScale();
        float f2 = 1.5f * f;
        float f3 = 2.5f * f;
        float f4 = 1.33f * f;
        float f5 = 1.0f * f;
        int n = Math.round(f4 + f2);
        int n2 = Math.round(f5 + f3);
        Image image = this.getImage(n + 1, n2 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(color);
        tGPainter.setForeground(color);
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, 0.0f, f3, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(Math.round(f4), Math.round(f3 + 0.33f));
        tGPainter.lineTo(Math.round(f4), 0.0f);
        tGPainter.lineTo(Math.round(f4 + f2), 0.0f);
        tGPainter.lineTo(Math.round(f4 + f2), Math.round(f3 + 0.33f));
        tGPainter.closePath();
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, f2, f3, f);
        tGPainter.closePath();
        tGPainter.dispose();
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getTripletFeel8(Color color) {
        float f = 5.0f * this.getLayout().getScale();
        float f2 = 1.0f * f;
        float f3 = 1.5f * f;
        float f4 = 2.5f * f;
        float f5 = 1.33f * f;
        float f6 = 1.0f * f;
        int n = Math.round(f5 * 2.0f + f3);
        int n2 = Math.round(f2 + f6 + f4);
        Image image = this.getImage(n + 1, n2 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(color);
        tGPainter.setForeground(color);
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, 0.0f, f2 + f4, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(Math.round(f5), Math.round(f2 + f4 + 0.33f));
        tGPainter.lineTo(Math.round(f5), f2);
        tGPainter.closePath();
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, f3, f2 + f4, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(Math.round(f5 + f3), Math.round(f2 + f4 + 0.33f));
        tGPainter.lineTo(Math.round(f5 + f3), f2);
        tGPainter.closePath();
        tGPainter.initPath(2);
        TGNotePainter.paintFooter(tGPainter, Math.round(f5 + f3), f2 + f * 2.3f, -1, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(0.0f, 1.0f * f);
        tGPainter.cubicTo(0.0f, 1.0f * f, (f5 * 2.0f + f3) / 2.0f, -1.0f * f, f5 * 2.0f + f3, 1.0f * f);
        tGPainter.closePath();
        tGPainter.dispose();
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getTripletFeelNone16(Color color) {
        float f = 5.0f * this.getLayout().getScale();
        float f2 = 1.5f * f;
        float f3 = 2.5f * f;
        float f4 = 1.33f * f;
        float f5 = 1.0f * f;
        int n = Math.round(f4 + f2);
        int n2 = Math.round(f5 + f3);
        Image image = this.getImage(n + 1, n2 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(color);
        tGPainter.setForeground(color);
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, 0.0f, f3, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(Math.round(f4), Math.round(f3 + 0.33f));
        tGPainter.lineTo(Math.round(f4), 0.0f);
        tGPainter.lineTo(Math.round(f4 + f2), 0.0f);
        tGPainter.lineTo(Math.round(f4 + f2), Math.round(f3 + 0.33f));
        tGPainter.moveTo(Math.round(f4), Math.round(0.5f * f));
        tGPainter.lineTo(Math.round(f4 + f2), Math.round(0.5f * f));
        tGPainter.closePath();
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, f2, f3, f);
        tGPainter.closePath();
        tGPainter.dispose();
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getTripletFeel16(Color color) {
        float f = 5.0f * this.getLayout().getScale();
        float f2 = 1.0f * f;
        float f3 = 1.5f * f;
        float f4 = 2.5f * f;
        float f5 = 1.33f * f;
        float f6 = 1.0f * f;
        int n = Math.round(f5 * 2.0f + f3);
        int n2 = Math.round(f2 + f6 + f4);
        Image image = this.getImage(n + 1, n2 + 2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(color);
        tGPainter.setForeground(color);
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, 0.0f, f2 + f4, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(Math.round(f5), Math.round(f2 + f4 + 0.33f));
        tGPainter.lineTo(Math.round(f5), f2);
        tGPainter.lineTo(Math.round(f5 + f3), f2);
        tGPainter.lineTo(Math.round(f5 + f3), Math.round(f2 + f4 + 0.33f));
        tGPainter.moveTo(Math.round(f5 + f3 - 0.55f * f), Math.round(f2 + 0.5f * f));
        tGPainter.lineTo(Math.round(f5 + f3), Math.round(f2 + 0.5f * f));
        tGPainter.closePath();
        tGPainter.initPath(2);
        TGNotePainter.paintNote(tGPainter, f3, f2 + f4, f);
        tGPainter.closePath();
        tGPainter.initPath();
        tGPainter.moveTo(0.0f, 1.0f * f);
        tGPainter.cubicTo(0.0f, 1.0f * f, (f5 * 2.0f + f3) / 2.0f, -1.0f * f, f5 * 2.0f + f3, 1.0f * f);
        tGPainter.closePath();
        tGPainter.dispose();
        return this.getImageMask(image, this.getBackgroundColor().getRGB(), color.getRGB());
    }

    private Image getImage(int n, int n2) {
        Image image = new Image((Device)this.getLayout().getTablature().getDisplay(), n, n2);
        TGPainter tGPainter = new TGPainter(new GC(image));
        tGPainter.setBackground(this.getBackgroundColor());
        tGPainter.initPath(2);
        tGPainter.addRectangle(0.0f, 0.0f, n, n2);
        tGPainter.closePath();
        tGPainter.dispose();
        return image;
    }

    private Image getImageMask(Image image, RGB rGB, RGB rGB2) {
        ImageData imageData = image.getImageData();
        ImageData imageData2 = ImageUtils.applyMask(imageData, rGB, rGB2);
        image.dispose();
        Image image2 = new Image((Device)this.getLayout().getTablature().getDisplay(), imageData, imageData2);
        this.resources.add(image2);
        return image2;
    }

    public void dispose() {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            resource.dispose();
        }
        this.resources.clear();
    }
}

