/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.editors.TGPainter;

public class TGMeasureBuffer {
    private Device device;
    private Image buffer;
    private TGPainter painter;
    private int width;
    private int height;

    public TGMeasureBuffer(Device device) {
        this.device = device;
    }

    public void makeBuffer(int n, int n2, Color color) {
        this.dispose();
        this.buffer = new Image(this.device, n, n2);
        this.width = n;
        this.height = n2;
        this.fillBuffer(color);
    }

    private void fillBuffer(Color color) {
        this.getPainter().setBackground(color);
        this.getPainter().initPath(2);
        this.getPainter().addRectangle(0.0f, 0.0f, this.width, this.height);
        this.getPainter().closePath();
    }

    public TGPainter getPainter() {
        if (this.painter == null || this.painter.getGC().isDisposed()) {
            this.painter = new TGPainter(this.buffer);
        }
        return this.painter;
    }

    public void paintImage(TGPainter tGPainter, int n, int n2, int n3) {
        tGPainter.drawImage(this.buffer, 0, n3, this.width, this.height - n3, n, n2 + n3, this.width, this.height - n3);
    }

    public Image getImage() {
        return this.buffer;
    }

    public void dispose() {
        if (this.painter != null && !this.painter.getGC().isDisposed()) {
            this.painter.dispose();
        }
        if (this.buffer != null && !this.buffer.isDisposed()) {
            this.buffer.dispose();
        }
    }

    public boolean isDisposed() {
        return this.buffer == null || this.buffer.isDisposed();
    }
}

