/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TrillEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    private Spinner fretSpinner;
    private Button sixtyFourthButton;
    private Button thirtySecondButton;
    private Button sixTeenthButton;
    protected TGEffectTrill result;

    public TGEffectTrill show(final TGNote tGNote) {
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout(new GridLayout());
        shell.setText(TuxGuitar.getProperty("effects.trill-editor"));
        Composite composite = new Composite(shell, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(4, 4, true, true));
        int n = 2;
        int n2 = tGNote.getValue();
        int n3 = 16;
        if (tGNote.getEffect().isTrill()) {
            n2 = tGNote.getEffect().getTrill().getFret();
            n3 = tGNote.getEffect().getTrill().getDuration().getValue();
        }
        Group group = this.makeGroup(composite, n, TuxGuitar.getProperty("note"));
        group.setLayout(new GridLayout(2, false));
        Label label = new Label(group, 0);
        label.setText(TuxGuitar.getProperty("fret") + ": ");
        this.fretSpinner = new Spinner(group, 2048);
        this.fretSpinner.setLayoutData(this.makeGridData(1));
        this.fretSpinner.setSelection(n2);
        Group group2 = this.makeGroup(composite, n, TuxGuitar.getProperty("duration"));
        group2.setLayout(new GridLayout(3, false));
        this.sixtyFourthButton = new Button(group2, 16);
        this.sixtyFourthButton.setImage(TuxGuitar.instance().getIconManager().getDuration(64));
        this.sixtyFourthButton.setLayoutData(this.makeGridData(1));
        this.sixtyFourthButton.setSelection(n3 == 64);
        this.thirtySecondButton = new Button(group2, 16);
        this.thirtySecondButton.setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.thirtySecondButton.setLayoutData(this.makeGridData(1));
        this.thirtySecondButton.setSelection(n3 == 32);
        this.sixTeenthButton = new Button(group2, 16);
        this.sixTeenthButton.setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.sixTeenthButton.setLayoutData(this.makeGridData(1));
        this.sixTeenthButton.setSelection(n3 == 16);
        Composite composite2 = new Composite(shell, 0);
        composite2.setLayout(new GridLayout(3, false));
        composite2.setLayoutData(new GridData(0x1000008, 1024, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrillEditor.this.result = TrillEditor.this.getTrill();
                shell.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrillEditor.this.result = null;
                shell.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TrillEditor.this.result = tGNote.getEffect().getTrill();
                shell.dispose();
            }
        });
        DialogUtils.openDialog(shell, 11);
        return this.result;
    }

    private Group makeGroup(Composite composite, int n, String string) {
        Group group = new Group(composite, 16);
        group.setLayoutData(this.makeGridData(n));
        group.setText(string);
        return group;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        return gridData;
    }

    public TGEffectTrill getTrill() {
        TGEffectTrill tGEffectTrill = TuxGuitar.instance().getSongManager().getFactory().newEffectTrill();
        tGEffectTrill.setFret(this.fretSpinner.getSelection());
        if (this.sixtyFourthButton.getSelection()) {
            tGEffectTrill.getDuration().setValue(64);
        } else if (this.thirtySecondButton.getSelection()) {
            tGEffectTrill.getDuration().setValue(32);
        } else if (this.sixTeenthButton.getSelection()) {
            tGEffectTrill.getDuration().setValue(16);
        } else {
            return null;
        }
        return tGEffectTrill;
    }
}

