/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;

public class GraceEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    private Spinner fretSpinner;
    private Button deadButton;
    private Button beforeBeatButton;
    private Button onBeatButton;
    private Button durationButton1;
    private Button durationButton2;
    private Button durationButton3;
    private Button pppButton;
    private Button ppButton;
    private Button pButton;
    private Button mpButton;
    private Button mfButton;
    private Button fButton;
    private Button ffButton;
    private Button fffButton;
    private Button noneButton;
    private Button slideButton;
    private Button bendButton;
    private Button hammerButton;
    protected TGEffectGrace result;
    private static final int LAYOUT_COLUMNS = 2;

    public TGEffectGrace show(final TGNote tGNote) {
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout(new GridLayout());
        shell.setText(TuxGuitar.getProperty("effects.grace-editor"));
        shell.setMinimumSize(360, 360);
        Composite composite = new Composite(shell, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        int n = 2;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = tGNote.getValue();
        int n3 = 1;
        int n4 = 95;
        int n5 = 0;
        if (tGNote.getEffect().isGrace()) {
            bl = tGNote.getEffect().getGrace().isDead();
            n2 = tGNote.getEffect().getGrace().getFret();
            bl2 = tGNote.getEffect().getGrace().isOnBeat();
            n3 = tGNote.getEffect().getGrace().getDuration();
            n4 = tGNote.getEffect().getGrace().getDynamic();
            n5 = tGNote.getEffect().getGrace().getTransition();
        }
        Group group = this.makeGroup(composite, n, TuxGuitar.getProperty("note"));
        group.setLayout(new GridLayout(2, false));
        Label label = new Label(group, 0);
        label.setText(TuxGuitar.getProperty("fret") + ": ");
        this.fretSpinner = new Spinner(group, 2048);
        this.fretSpinner.setLayoutData(this.makeGridData(1));
        this.fretSpinner.setSelection(n2);
        this.deadButton = new Button(group, 32);
        this.deadButton.setText(TuxGuitar.getProperty("note.deadnote"));
        this.deadButton.setLayoutData(this.makeGridData(2));
        this.deadButton.setSelection(bl);
        Group group2 = this.makeGroup(composite, n, TuxGuitar.getProperty("position"));
        group2.setLayout(new GridLayout());
        this.beforeBeatButton = new Button(group2, 16);
        this.beforeBeatButton.setText(TuxGuitar.getProperty("effects.grace.before-beat"));
        this.beforeBeatButton.setLayoutData(this.makeGridData(1));
        this.beforeBeatButton.setSelection(!bl2);
        this.onBeatButton = new Button(group2, 16);
        this.onBeatButton.setText(TuxGuitar.getProperty("effects.grace.on-beat"));
        this.onBeatButton.setLayoutData(this.makeGridData(1));
        this.onBeatButton.setSelection(bl2);
        Group group3 = this.makeGroup(composite, n, TuxGuitar.getProperty("duration"));
        group3.setLayout(new GridLayout(3, false));
        this.durationButton1 = new Button(group3, 16);
        this.durationButton1.setImage(TuxGuitar.instance().getIconManager().getDuration(64));
        this.durationButton1.setLayoutData(this.makeGridData(1));
        this.durationButton1.setSelection(n3 == 1);
        this.durationButton2 = new Button(group3, 16);
        this.durationButton2.setImage(TuxGuitar.instance().getIconManager().getDuration(32));
        this.durationButton2.setLayoutData(this.makeGridData(1));
        this.durationButton2.setSelection(n3 == 2);
        this.durationButton3 = new Button(group3, 16);
        this.durationButton3.setImage(TuxGuitar.instance().getIconManager().getDuration(16));
        this.durationButton3.setLayoutData(this.makeGridData(1));
        this.durationButton3.setSelection(n3 == 3);
        n = 1;
        Group group4 = this.makeGroup(composite, n, TuxGuitar.getProperty("dynamic"));
        group4.setLayout(new GridLayout(2, false));
        this.pppButton = new Button(group4, 16);
        this.pppButton.setImage(TuxGuitar.instance().getIconManager().getDynamicPPP());
        this.pppButton.setLayoutData(this.makeGridData(1));
        this.pppButton.setSelection(n4 == 15);
        this.mfButton = new Button(group4, 16);
        this.mfButton.setImage(TuxGuitar.instance().getIconManager().getDynamicMF());
        this.mfButton.setLayoutData(this.makeGridData(1));
        this.mfButton.setSelection(n4 == 79);
        this.ppButton = new Button(group4, 16);
        this.ppButton.setImage(TuxGuitar.instance().getIconManager().getDynamicPP());
        this.ppButton.setLayoutData(this.makeGridData(1));
        this.ppButton.setSelection(n4 == 31);
        this.fButton = new Button(group4, 16);
        this.fButton.setImage(TuxGuitar.instance().getIconManager().getDynamicF());
        this.fButton.setLayoutData(this.makeGridData(1));
        this.fButton.setSelection(n4 == 95);
        this.pButton = new Button(group4, 16);
        this.pButton.setImage(TuxGuitar.instance().getIconManager().getDynamicP());
        this.pButton.setLayoutData(this.makeGridData(1));
        this.pButton.setSelection(n4 == 47);
        this.ffButton = new Button(group4, 16);
        this.ffButton.setImage(TuxGuitar.instance().getIconManager().getDynamicFF());
        this.ffButton.setLayoutData(this.makeGridData(1));
        this.ffButton.setSelection(n4 == 111);
        this.mpButton = new Button(group4, 16);
        this.mpButton.setImage(TuxGuitar.instance().getIconManager().getDynamicMP());
        this.mpButton.setLayoutData(this.makeGridData(1));
        this.mpButton.setSelection(n4 == 63);
        this.fffButton = new Button(group4, 16);
        this.fffButton.setImage(TuxGuitar.instance().getIconManager().getDynamicFFF());
        this.fffButton.setLayoutData(this.makeGridData(1));
        this.fffButton.setSelection(n4 == 127);
        Group group5 = this.makeGroup(composite, n, TuxGuitar.getProperty("effects.grace.transition"));
        group5.setLayout(new GridLayout());
        this.noneButton = new Button(group5, 16);
        this.noneButton.setText(TuxGuitar.getProperty("effects.grace.transition-none"));
        this.noneButton.setLayoutData(this.makeGridData(1));
        this.noneButton.setSelection(n5 == 0);
        this.bendButton = new Button(group5, 16);
        this.bendButton.setText(TuxGuitar.getProperty("effects.grace.transition-bend"));
        this.bendButton.setLayoutData(this.makeGridData(1));
        this.bendButton.setSelection(n5 == 2);
        this.slideButton = new Button(group5, 16);
        this.slideButton.setText(TuxGuitar.getProperty("effects.grace.transition-slide"));
        this.slideButton.setLayoutData(this.makeGridData(1));
        this.slideButton.setSelection(n5 == 1);
        this.hammerButton = new Button(group5, 16);
        this.hammerButton.setText(TuxGuitar.getProperty("effects.grace.transition-hammer"));
        this.hammerButton.setLayoutData(this.makeGridData(1));
        this.hammerButton.setSelection(n5 == 3);
        Composite composite2 = new Composite(shell, 0);
        composite2.setLayout(new GridLayout(3, false));
        composite2.setLayoutData(new GridData(0x1000008, 1024, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraceEditor.this.result = GraceEditor.this.getGrace();
                shell.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraceEditor.this.result = null;
                shell.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GraceEditor.this.result = tGNote.getEffect().getGrace();
                shell.dispose();
            }
        });
        DialogUtils.openDialog(shell, 11);
        return this.result;
    }

    private Group makeGroup(Composite composite, int n, String string) {
        Group group = new Group(composite, 16);
        group.setLayoutData(this.makeGridData(n));
        group.setText(string);
        return group;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData makeGridData(int n) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        return gridData;
    }

    public TGEffectGrace getGrace() {
        TGEffectGrace tGEffectGrace = TuxGuitar.instance().getSongManager().getFactory().newEffectGrace();
        tGEffectGrace.setFret(this.fretSpinner.getSelection());
        tGEffectGrace.setDead(this.deadButton.getSelection());
        tGEffectGrace.setOnBeat(this.onBeatButton.getSelection());
        if (this.durationButton1.getSelection()) {
            tGEffectGrace.setDuration(1);
        } else if (this.durationButton2.getSelection()) {
            tGEffectGrace.setDuration(2);
        } else if (this.durationButton3.getSelection()) {
            tGEffectGrace.setDuration(3);
        }
        if (this.pppButton.getSelection()) {
            tGEffectGrace.setDynamic(15);
        } else if (this.ppButton.getSelection()) {
            tGEffectGrace.setDynamic(31);
        } else if (this.pButton.getSelection()) {
            tGEffectGrace.setDynamic(47);
        } else if (this.mpButton.getSelection()) {
            tGEffectGrace.setDynamic(63);
        } else if (this.mfButton.getSelection()) {
            tGEffectGrace.setDynamic(79);
        } else if (this.fButton.getSelection()) {
            tGEffectGrace.setDynamic(95);
        } else if (this.ffButton.getSelection()) {
            tGEffectGrace.setDynamic(111);
        } else if (this.fffButton.getSelection()) {
            tGEffectGrace.setDynamic(127);
        }
        if (this.noneButton.getSelection()) {
            tGEffectGrace.setTransition(0);
        } else if (this.slideButton.getSelection()) {
            tGEffectGrace.setTransition(1);
        } else if (this.bendButton.getSelection()) {
            tGEffectGrace.setTransition(2);
        } else if (this.hammerButton.getSelection()) {
            tGEffectGrace.setTransition(3);
        }
        return tGEffectGrace;
    }
}

