/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.settings;

import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.system.plugins.TGPlugin;
import org.herac.tuxguitar.gui.system.plugins.TGPluginSetup;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class EditPluginsAction
extends Action {
    public static final String NAME = "action.settings.plugins";
    private static final int TABLE_WIDTH = 400;
    private static final int TABLE_HEIGHT = 300;

    public EditPluginsAction() {
        super(NAME, 7);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog();
        return 0;
    }

    public void showDialog() {
        Widget widget;
        Object object;
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout(new GridLayout());
        shell.setLayoutData(new GridData(4, 4, true, true));
        shell.setText(TuxGuitar.getProperty("plugins"));
        final Table table = new Table(shell, 68388);
        table.setLayoutData(new GridData(400, 300));
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn.setText(TuxGuitar.getProperty("plugin.column.enabled"));
        tableColumn2.setText(TuxGuitar.getProperty("plugin.column.name"));
        tableColumn.setWidth(100);
        tableColumn2.setWidth(300);
        Iterator iterator = TuxGuitar.instance().getPluginManager().getPlugins().iterator();
        while (iterator.hasNext()) {
            object = (TGPlugin)iterator.next();
            widget = new TableItem(table, 0);
            widget.setData(object);
            ((TableItem)widget).setText(1, object.getName() != null ? object.getName() : "Undefined Plugin");
            ((TableItem)widget).setChecked(TuxGuitar.instance().getPluginManager().isEnabled((TGPlugin)object));
        }
        object = new Composite(shell, 0);
        ((Composite)object).setLayout(new GridLayout(3, false));
        ((Control)object).setLayoutData(new GridData(131072, 4, true, true));
        widget = new Button((Composite)object, 8);
        ((Button)widget).setText(TuxGuitar.getProperty("configure"));
        ((Control)widget).setLayoutData(this.getButtonData());
        ((Control)widget).setEnabled(false);
        ((Button)widget).addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = table.getItem(table.getSelectionIndex());
                if (tableItem != null && tableItem.getData() instanceof TGPluginSetup) {
                    ((TGPluginSetup)tableItem.getData()).setupDialog(shell);
                }
            }
        });
        final Button button = new Button((Composite)object, 8);
        button.setText(TuxGuitar.getProperty("info"));
        button.setLayoutData(this.getButtonData());
        button.setEnabled(false);
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = table.getItem(table.getSelectionIndex());
                if (tableItem != null && tableItem.getData() instanceof TGPlugin) {
                    EditPluginsAction.this.showInfo(shell, (TGPlugin)tableItem.getData());
                }
            }
        });
        Button button2 = new Button((Composite)object, 8);
        button2.setText(TuxGuitar.getProperty("exit"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.dispose();
            }
        });
        table.addListener(13, new Listener((Button)widget, shell, table){
            private final /* synthetic */ Button val$buttonSetup;
            private final /* synthetic */ Shell val$dialog;
            private final /* synthetic */ Table val$table;
            {
                this.val$buttonSetup = button2;
                this.val$dialog = shell;
                this.val$table = table;
            }

            public void handleEvent(Event event) {
                button.setEnabled(false);
                this.val$buttonSetup.setEnabled(false);
                if (event.item instanceof TableItem && event.item.getData() instanceof TGPlugin) {
                    TableItem tableItem = (TableItem)event.item;
                    if (event.detail == 32) {
                        TuxGuitar.instance().loadCursor(this.val$dialog, 1);
                        TuxGuitar.instance().getPluginManager().setEnabled((TGPlugin)tableItem.getData(), tableItem.getChecked());
                        TuxGuitar.instance().loadCursor(this.val$dialog, 0);
                        this.val$table.setSelection(tableItem);
                    }
                    button.setEnabled(true);
                    this.val$buttonSetup.setEnabled(tableItem.getData() instanceof TGPluginSetup);
                }
            }
        });
        DialogUtils.openDialog(shell, 3);
    }

    public void showInfo(Shell shell, TGPlugin tGPlugin) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setLayoutData(new GridData(4, 4, true, true));
        shell2.setText(TuxGuitar.getProperty("plugins"));
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(2, false));
        this.showInfoString(composite, TuxGuitar.getProperty("name") + ":", tGPlugin.getName());
        this.showInfoString(composite, TuxGuitar.getProperty("version") + ":", tGPlugin.getVersion());
        this.showInfoString(composite, TuxGuitar.getProperty("author") + ":", tGPlugin.getAuthor());
        this.showInfoString(composite, TuxGuitar.getProperty("description") + ":", tGPlugin.getDescription());
        Composite composite2 = new Composite(shell2, 0);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(131072, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("exit"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        DialogUtils.openDialog(shell2, 3);
    }

    private void showInfoString(Composite composite, String string, String string2) {
        Label label = new Label(composite, 16384);
        Label label2 = new Label(composite, 16448);
        label.setLayoutData(new GridData(16384, 128, false, true));
        label2.setLayoutData(new GridData(4, 128, true, true));
        this.setBold(label);
        label.setText(string);
        label2.setText(string2 != null && string2.length() > 0 ? string2 : TuxGuitar.getProperty("plugin.unknown-value"));
    }

    private void setBold(Label label) {
        FontData[] fontDataArray = label.getFont().getFontData();
        if (fontDataArray.length > 0) {
            final Font font = new Font((Device)label.getDisplay(), fontDataArray[0].getName(), fontDataArray[0].getHeight(), 1);
            label.setFont(font);
            label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    font.dispose();
                }
            });
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }
}

