/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tef;

import java.util.Iterator;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;

class TGSongAdjuster {
    protected TGSongManager manager;

    public TGSongAdjuster(TGSongManager tGSongManager) {
        this.manager = tGSongManager;
    }

    public TGSong process() {
        Iterator iterator = this.manager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            Iterator iterator2 = tGTrack.getMeasures();
            while (iterator2.hasNext()) {
                TGMeasure tGMeasure = (TGMeasure)iterator2.next();
                this.process(tGMeasure);
            }
        }
        return this.manager.getSong();
    }

    public void process(TGMeasure tGMeasure) {
        this.manager.getMeasureManager().orderBeats(tGMeasure);
        this.adjustBeats(tGMeasure);
    }

    public void adjustBeats(TGMeasure tGMeasure) {
        TGBeat tGBeat = null;
        boolean bl = true;
        long l = tGMeasure.getStart();
        long l2 = l + tGMeasure.getLength();
        for (int i = 0; i < tGMeasure.countBeats(); ++i) {
            TGBeat tGBeat2 = tGMeasure.getBeat(i);
            long l3 = tGBeat2.getStart();
            long l4 = tGBeat2.getDuration().getTime();
            if (tGBeat != null) {
                TGDuration tGDuration;
                long l5 = tGBeat.getStart();
                long l6 = tGBeat.getDuration().getTime();
                if (tGBeat2.isRestBeat() && tGBeat2.isChordBeat()) {
                    tGDuration = null;
                    TGBeat tGBeat3 = this.manager.getMeasureManager().getFirstBeat(tGMeasure.getBeats());
                    while (tGBeat3 != null && (tGDuration == null || tGBeat3.getStart() <= tGBeat2.getStart())) {
                        if (!tGBeat3.isRestBeat() && !tGBeat3.isChordBeat()) {
                            tGDuration = tGBeat3;
                        }
                        tGBeat3 = this.manager.getMeasureManager().getNextBeat(tGMeasure.getBeats(), tGBeat3);
                    }
                    if (tGDuration != null) {
                        tGDuration.setChord(tGBeat2.getChord());
                    }
                    tGMeasure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                if (l5 < l3 && l5 + l6 > l3) {
                    if (tGBeat2.isRestBeat()) {
                        tGMeasure.removeBeat(tGBeat2);
                        bl = false;
                        break;
                    }
                    tGDuration = TGDuration.fromTime((TGFactory)this.manager.getFactory(), (long)(l3 - l5));
                    tGDuration.copy(tGBeat.getDuration());
                }
            }
            if (l3 + l4 > l2) {
                if (tGBeat2.isRestBeat()) {
                    tGMeasure.removeBeat(tGBeat2);
                    bl = false;
                    break;
                }
                TGDuration tGDuration = TGDuration.fromTime((TGFactory)this.manager.getFactory(), (long)(l2 - l3));
                tGDuration.copy(tGBeat2.getDuration());
            }
            tGBeat = tGBeat2;
        }
        if (!bl) {
            this.adjustBeats(tGMeasure);
        }
    }
}

