/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tef;

import java.io.IOException;
import java.io.InputStream;
import org.herac.tuxguitar.io.tef.base.TEChord;
import org.herac.tuxguitar.io.tef.base.TEComponentChord;
import org.herac.tuxguitar.io.tef.base.TEComponentNote;
import org.herac.tuxguitar.io.tef.base.TEInfo;
import org.herac.tuxguitar.io.tef.base.TEPercussion;
import org.herac.tuxguitar.io.tef.base.TERepeat;
import org.herac.tuxguitar.io.tef.base.TERhythm;
import org.herac.tuxguitar.io.tef.base.TESong;
import org.herac.tuxguitar.io.tef.base.TETempo;
import org.herac.tuxguitar.io.tef.base.TEText;
import org.herac.tuxguitar.io.tef.base.TETimeSignature;
import org.herac.tuxguitar.io.tef.base.TETimeSignatureChange;
import org.herac.tuxguitar.io.tef.base.TETrack;

public class TEInputStream {
    private TESong song;
    private InputStream stream;

    public TEInputStream(InputStream inputStream) {
        this.stream = inputStream;
    }

    public TESong readSong() {
        this.song = new TESong();
        this.readInfo();
        this.song.setMeasures(this.readByte() & 0xFF);
        this.skip(1);
        this.readTimeSignature();
        this.skip(15);
        this.readTempo();
        this.song.setRepeats(this.readByte() & 0xFF);
        this.skip(5);
        this.song.setTexts(this.readByte() & 0xFF);
        this.skip(5);
        this.song.setPercussions(this.readByte() & 0xFF);
        this.song.setRhythms(this.readByte() & 0xFF);
        this.song.setChords(this.readByte() & 0xFF);
        this.skip(1);
        boolean bl = (this.readByte() & 0xFF) > 0;
        this.skip(1);
        this.song.setStrings(this.readByte() & 0xFF);
        this.song.setTracks((this.readByte() & 0xFF) + 1);
        this.skip(14);
        this.readComponents();
        this.readRepeats();
        this.readTexts();
        this.readPercussions();
        this.readChords();
        this.readRhythms();
        this.readNotes(bl);
        this.readTracks();
        this.close();
        return this.song;
    }

    private void readInfo() {
        byte[] byArray = this.readBytes(200);
        int n = 0;
        String[] stringArray = new String[3];
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = 0;
            while (n + n2 < byArray.length && byArray[n + n2] != 0) {
                ++n2;
            }
            stringArray[i] = new String(byArray, n, n2);
            n += n2 + 1;
        }
        this.song.setInfo(new TEInfo(stringArray[0], stringArray[1], stringArray[2]));
    }

    private void readNotes(boolean bl) {
        if (bl) {
            int n = this.readShort();
            this.song.getInfo().setNotes(new String(this.readBytes(n), 1, n - 1));
        }
    }

    private void readTempo() {
        int n = this.readShort();
        this.song.setTempo(new TETempo(n));
    }

    private void readTimeSignature() {
        int n = this.readByte();
        this.skip(1);
        int n2 = this.readByte();
        this.song.setTimeSignature(new TETimeSignature(n, n2));
    }

    private void readRepeats() {
        for (int i = 0; i < this.song.getRepeats().length; ++i) {
            int n = this.readByte();
            int n2 = this.readByte();
            this.song.setRepeat(i, new TERepeat(n, n2));
        }
    }

    private void readTexts() {
        for (int i = 0; i < this.song.getTexts().length; ++i) {
            int n = this.readByte();
            byte[] byArray = this.readBytes(n);
            this.song.setText(i, new TEText(new String(byArray, 1, n - 1)));
            this.skip(1);
        }
    }

    private void readChords() {
        for (int i = 0; i < this.song.getChords().length; ++i) {
            byte[] byArray = this.readBytes(14);
            byte[] byArray2 = this.readBytes(16);
            this.song.setChord(i, new TEChord(byArray, new String(byArray2)));
            this.skip(2);
        }
    }

    private void readPercussions() {
        if (this.song.getPercussions().length > 0) {
            for (int i = 0; i < this.song.getPercussions().length; ++i) {
                this.skip(96);
                String string = new String(this.readBytes(8));
                this.skip(1);
                int n = this.readByte() & 0xFF;
                this.song.setPercussion(i, new TEPercussion(string, n));
                this.skip(2);
            }
            this.skip(this.song.getMeasures());
        }
    }

    private void readRhythms() {
        if (this.song.getRhythms().length > 0) {
            for (int i = 0; i < this.song.getRhythms().length; ++i) {
                this.skip(96);
                String string = new String(this.readBytes(8));
                this.skip(1);
                int n = this.readByte() & 0xFF;
                int n2 = this.readByte() & 0xFF;
                this.song.setRhythm(i, new TERhythm(string, n, n2));
                this.skip(1);
            }
            this.skip(this.song.getMeasures());
        }
    }

    private void readTracks() {
        for (int i = 0; i < this.song.getTracks().length; ++i) {
            int[] nArray = new int[this.readByte()];
            this.skip(5);
            int n = this.readByte();
            this.skip(1);
            int n2 = this.readByte();
            this.skip(3);
            int n3 = this.readByte();
            this.skip(1);
            int n4 = this.readByte();
            int n5 = this.readByte();
            this.skip(1);
            int n6 = this.readByte();
            int n7 = this.readByte();
            int n8 = this.readByte();
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = this.readByte() & 0xFF;
            }
            this.skip(12 - nArray.length);
            String string = new String(this.readBytes(16));
            this.song.setTrack(i, new TETrack(n == 98, n2, n3, n4, n5, n6, n7, n8, nArray, string));
            this.skip(2);
        }
    }

    private void readComponents() {
        int n = 256 * this.song.getTimeSignature().getNumerator() / this.song.getTimeSignature().getDenominator();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.readShort();
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7;
            byte[] byArray = this.readBytes(6);
            int n8 = (byArray[0] & 0xFF) + 256 * (n4 + (byArray[1] & 0xFF));
            if (n8 / (n * this.song.getStrings()) < n3) {
                n8 = (byArray[0] & 0xFF) + 256 * ((n4 += 256) + (byArray[1] & 0xFF));
            }
            int n9 = n8 % n;
            int n10 = n8 / n % this.song.getStrings();
            int n11 = n8 / (n * this.song.getStrings());
            n2 = n3 == n11 ? n2 : 0;
            n9 -= n2;
            if ((byArray[2] & 0xFF & 0x1F) > 0 && (byArray[2] & 0xFF & 0x1F) <= 25) {
                n7 = byArray[3] & 0xF;
                n6 = byArray[3] >> 4;
                byte by = byArray[4];
                int n12 = (byArray[2] & 0xFF & 0x1F) - 1;
                if (((byArray[2] & 0xFF) >> 5 & 1) != 0) {
                    n12 += byArray[5] & 0xFF;
                }
                this.song.getComponents().add(new TEComponentNote(n9, n11, n10, n12, n7, n6, by));
            } else if ((byArray[2] & 0xFF & 0x1F) == 27) {
                n2 = 4 * (byArray[3] & 0xFF);
                n7 = (int)(Math.pow(2.0, (byArray[2] & 0xFF) >> 5) / 2.0);
                n6 = (n / 4 - (byArray[3] & 0xFF)) * n7 / 64;
                this.song.addTimeSignatureChange(new TETimeSignatureChange(n11, new TETimeSignature(n6, n7)));
            } else if ((byArray[2] & 0xFF & 0x1F) != 28 || (byArray[2] & 0x20) == 0) {
                if ((byArray[2] & 0xFF & 0x1F) == 28) {
                    this.song.getComponents().add(new TEComponentChord(n9, n11, n10, byArray[3]));
                } else if ((byArray[2] & 0xFF & 0x1F) == 29 || (byArray[2] & 0xFF & 0x1F) == 30) {
                    // empty if block
                }
            }
            n3 = n11;
        }
    }

    protected byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        try {
            this.stream.read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    protected int readByte() {
        try {
            return this.stream.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    protected int readShort() {
        try {
            byte[] byArray = new byte[2];
            this.stream.read(byArray);
            return (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
    }

    protected void skip(int n) {
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
    }

    protected void close() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

