/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Measure implements Serializable{
    private long start;
    private List notes;
    private List silences;
    private TimeSignature timeSignature;
    private Tempo tempo;
    private boolean repeatStart;
    private int numberOfRepetitions;
    private long startWidthRepetitions;
    
    public Measure(long start,List notes,List silences,TimeSignature timeSignature,Tempo tempo,boolean repeatStart,int numberOfRepetitions){
        this.start = start;
        this.notes = notes;
        this.silences = silences;
        this.timeSignature = timeSignature;
        this.tempo = tempo;
        this.repeatStart = repeatStart;
        this.numberOfRepetitions = numberOfRepetitions;
        this.startWidthRepetitions = this.start;
    }
    
    public long getStart() {
        return start;
    }
    public void setStart(long start) {
        this.start = start;
    }
    public List getNotes() {
        return notes;
    }
    public void setNotes(List notes) {
        this.notes = notes;
    }           
    public void removeNote(Note note){
        this.notes.remove(note);
    }    
    public void addNote(Note note){
        this.notes.add(note);
    }    
    public List getSilences() {
        return silences;
    }
    public void setSilences(List silences) {
        this.silences = silences;
    }
    public void removeSilence(Silence silence){
        this.silences.remove(silence);
    }    
    public void addSilence(Silence silence){
        this.silences.add(silence);
    }    
    public TimeSignature getTimeSignature() {
        return timeSignature;
    }
    public void setTimeSignature(TimeSignature timeSignature) {
        this.timeSignature = timeSignature;
    }        
    public Tempo getTempo() {
        return tempo;
    }
    public void setTempo(Tempo tempo) {
        this.tempo = tempo;
    }    
    
    public int getNumberOfRepetitions() {
        return numberOfRepetitions;
    }
    public void setNumberOfRepetitions(int numberOfRepetitions) {
        this.numberOfRepetitions = numberOfRepetitions;
    }
    public boolean isRepeatStart() {
        return repeatStart;
    }
    public void setRepeatStart(boolean repeatStart) {
        this.repeatStart = repeatStart;
    }
        
    public long getStartWidthRepetitions() {
        return startWidthRepetitions;
    }
    public void setStartWidthRepetitions(long startWidthRepetitions) {
        this.startWidthRepetitions = startWidthRepetitions;
    }    
    
    public long getLength(){
        return getTimeSignature().getNumerator() * getTimeSignature().getDenominator().getTime();
    }

    
    
    
    
    public Object clone(){
        long start = this.start;
        boolean repeatStart = this.repeatStart;
        int numberOfRepetitions = this.numberOfRepetitions;
        List notes = new ArrayList();
        List silences = new ArrayList();
        TimeSignature timeSignature = (TimeSignature)this.timeSignature.clone();
        Tempo tempo = (Tempo)this.tempo.clone();
        
        for(int i = 0;i < this.notes.size();i++){
            Note note = (Note)this.notes.get(i);
            notes.add(note.clone());
        }
        for(int i = 0;i < this.silences.size();i++){
            Silence silence = (Silence)this.silences.get(i);
            silences.add(silence.clone());
        }
        
        return new Measure(start,notes,silences,timeSignature,tempo,repeatStart,numberOfRepetitions);
    }
    
}
