/*
 * Created on 13-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.play.models.midiplayer;

import java.util.Iterator;
import java.util.List;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongSequence {    
    /**
     * Sequencia de la cancion
     */
    private Sequence sequence;
    /**
     * Cancion
     */
    private Song song;
    /**
     * Repeticiones de la Cancion
     */
    
    public SongSequence(Song song) {
        this.song = song;
    }

    public void createSongSecuence() {
        this.createSecuence();
    }

    public Sequence getSongSecuence() {
        return this.sequence;
    }
    
    /**
     * Crea la cancion
     */        
    private void createSecuence() {
        try {
            sequence = new Sequence(Sequence.PPQ, 1);

            Iterator it = this.song.getTracks().iterator();
            for (int trackIdx = 0; trackIdx < this.song.getTracks().size(); trackIdx++) {
                SongTrack songTrack = (SongTrack) this.song.getTracks().get(trackIdx);
                createTrack(songTrack,(trackIdx == 0));
            }

            addTimeSignature(new TimeSignature(4, new Duration(Duration.QUARTER)), 0, sequence.getTracks()[0]);
            addTempo(new Tempo(100), 0, sequence.getTracks()[0]);

        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /**
     * Crea las pistas de la cancion
     */        
    private void createTrack(SongTrack songTrack,boolean firstTrack) {
        try {
            Track midiTrack = sequence.createTrack();
            createInstrument(midiTrack, songTrack.getChannel(), songTrack.getInstrument());

            //------controlo las repeticiones-------
            long repeatStart = 1000;
            boolean repeatOpen = true;
            long repeatEnd = 0;
            long startMove = 0;
            int repeatStartIndex = 0;
            int repeatNumber = 0;
            //--------------------------------------

            Measure prevMeasure = null;
            for (int measureIdx = 0; measureIdx < songTrack.getMeasures().size(); measureIdx++) {
                Measure measure = (Measure) songTrack.getMeasures().get(measureIdx);
                                    
                if(firstTrack){
                    makeMeasureStartMetaMessage(midiTrack, measureIdx, measure,startMove);
                }
                //agrego las notas
                createNotes(midiTrack, songTrack, measure, measureIdx, startMove);

                //agrego el tempo y ritmo------------------------------------
                addTimeSignature(measure, prevMeasure,startMove, midiTrack);
                addTempo(measure, prevMeasure,startMove,midiTrack);
                //-----------------------------------------------------------

                //guardo el indice de el compas donde empieza una repeticion
                if (measure.isRepeatStart()) {
                    repeatStartIndex = measureIdx;
                    repeatStart = measure.getStart();
                    repeatOpen = true;
                }

                //si hay una repeticion la hago
                if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
                    if (repeatNumber < measure.getNumberOfRepetitions()) {
                        repeatEnd = measure.getStart() + measure.getLength();
                        startMove += repeatEnd - repeatStart;
                        measureIdx = repeatStartIndex - 1;
                        repeatNumber++;
                    } else {
                        repeatStart = 0;
                        repeatNumber = 0;
                        repeatEnd = 0;
                        repeatOpen = false;
                    }
                }

                prevMeasure = measure;
            }

        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /**
     * Crea las notas del compas
     */    
    private void createNotes(Track midiTrack, SongTrack songTrack, Measure measure, int measureIdx, long startMove) {
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            if (!note.isTiedNote()) {
                int key = note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                long start = note.getStart() + startMove;
                long duration = getRealNoteDuration(note, songTrack.getMeasures(), measureIdx, noteIdx);
                int velocity = note.getVelocity();
                createNote(midiTrack, key, start, duration, velocity, songTrack.getChannel());
            }
        }

    }

    /**
     * Crea una nota en la posicion start
     */
    private void createNote(Track track, int key, long start, long duration, int velocity, int channel) {
        try {
            ShortMessage messageOn = new ShortMessage();
            ShortMessage messageOff = new ShortMessage();

            messageOn.setMessage(ShortMessage.NOTE_ON, channel, key, velocity);
            messageOff.setMessage(ShortMessage.NOTE_OFF, channel, key, velocity);

            track.add(new MidiEvent(messageOn, start));
            track.add(new MidiEvent(messageOff, start + duration));

        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    /**
     * Crea el instrumento para la pista
     */
    private void createInstrument(Track track, int channel, int instrument) {
        try {
            ShortMessage message = new ShortMessage();
            message.setMessage(ShortMessage.PROGRAM_CHANGE, channel, instrument, 0);
            track.add(new MidiEvent(message, 0));
        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /**
     * Agrega un Time Signature si es distinto al anterior
     */
    private void addTimeSignature(Measure currMeasure, Measure prevMeasure,long startMove,Track track) throws InvalidMidiDataException {
        boolean addTimeSignature = false;
        if (prevMeasure == null) {
            addTimeSignature = true;
        } else {
            int currNumerator = currMeasure.getTimeSignature().getNumerator();
            int currValue = currMeasure.getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getTimeSignature().getDenominator().getValue();
            if (currNumerator != prevNumerator || currValue != prevValue) {
                addTimeSignature = true;
            }
        }
        if (addTimeSignature) {
            addTimeSignature(currMeasure.getTimeSignature(), currMeasure.getStart() + startMove, track);
        }
    }

    /**
     * Agrega un Time Signature
     */
    private void addTimeSignature(TimeSignature timeSignature, long tick, Track track) throws InvalidMidiDataException {
        MetaMessage metaMessage = new MetaMessage();
        byte data[] = new byte[4];
        data[0] = (byte) timeSignature.getNumerator();

        if (timeSignature.getDenominator().getValue() == 1) {
            data[1] = 0;
        } else if (timeSignature.getDenominator().getValue() == 2) {
            data[1] = 1;
        } else if (timeSignature.getDenominator().getValue() == 4) {
            data[1] = 2;
        } else if (timeSignature.getDenominator().getValue() == 8) {
            data[1] = 3;
        } else if (timeSignature.getDenominator().getValue() == 16) {
            data[1] = 4;
        } else if (timeSignature.getDenominator().getValue() == 32) {
            data[1] = 5;
        } else {
            throw new InvalidMidiDataException();
        }

        data[2] = (byte) (96 / timeSignature.getDenominator().getValue());
        data[3] = 8;
        metaMessage.setMessage(0x58, data, 4);

        MidiEvent midiEvent = new MidiEvent(metaMessage, tick);
        track.add(midiEvent);
    }

    /**
     * Agrega un Tempo si es distinto al anterior
     */
    private void addTempo(Measure currMeasure, Measure prevMeasure,long startMove, Track track) throws InvalidMidiDataException {
        boolean addTempo = false;
        if (prevMeasure == null) {
            addTempo = true;
        } else {
            if (currMeasure.getTempo().getValue() != prevMeasure.getTempo().getValue()) {
                addTempo = true;
            }
        }
        if (addTempo) {
            addTempo(currMeasure.getTempo(), currMeasure.getStart() + startMove, track);
        }
    }

    /**
     * Agrega un Tempo
     */
    private void addTempo(Tempo tempo, long tick, Track track) throws InvalidMidiDataException {
        int usq = (int) tempo.getInMillis();
        MetaMessage metaMessage = new MetaMessage();
        byte[] data = new byte[3];

        data[0] = (byte) ((usq >> 16) & 0x00FF);
        data[1] = (byte) ((usq >> 8) & 0x00FF);
        data[2] = (byte) ((usq) & 0x00FF);
        metaMessage.setMessage(0x51, data, 3);

        MidiEvent midiEvent = new MidiEvent(metaMessage, tick);
        track.add(midiEvent);
    }

    /**
     * Retorna la Duracion real de una nota, verificando si tiene otras ligadas
     */
    private long getRealNoteDuration(Note note, List measures, int measureIndex, int noteIndex) {
        long duration = note.getDuration().getTime();
        noteIndex++;
        for (int mIdx = measureIndex; mIdx < measures.size(); mIdx++) {
            Measure measure = (Measure) measures.get(mIdx);
            for (int nIdx = noteIndex; nIdx < measure.getNotes().size(); nIdx++) {
                Note nextNote = (Note) measure.getNotes().get(nIdx);
                if (!nextNote.equals(note)) {
                    if (nextNote.getString() == note.getString()) {
                        if (nextNote.isTiedNote()) {
                            duration += nextNote.getDuration().getTime();
                        } else {
                            return duration;
                        }
                    }
                }
            }
            noteIndex = 0;
        }
        return duration;
    }

    
    /**
     * Agrega un Meta Message para el evento de cada compas
     */
    public void makeMeasureStartMetaMessage(Track track, int index, Measure measure,long startMove) {
        MetaMessage metaMessage = new MetaMessage();

        String start = Long.toString(measure.getStart());
        byte data[] = start.getBytes();
                
        try {
            metaMessage.setMessage(MeasureStartMetaEventListener.MEASURE_START, data, data.length);
            MidiEvent event = new MidiEvent(metaMessage, measure.getStart() + startMove);
            track.add(event);
        } catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }
    
}