/*
 * Created on 09-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TGConverter {
    private String sourceFolder;
    private String destinationFolder;
    
    public TGConverter(String sourceFolder,String destinationFolder){
        this.sourceFolder = sourceFolder;
        this.destinationFolder = destinationFolder;
    }
    
    public void convert(String gp3FileName, String tgFileName) throws GPFormatException, IOException {
        Song song = new SongLoader(gp3FileName).load();
        if(song != null){
            new TGOutputStream(tgFileName).write(song); 
        }
    }

    private void process(File folder) {
        String[] fileNames = folder.list();

        for (int i = 0; i < fileNames.length; i++) {
            File file = new File(folder.getPath() + "/" + fileNames[i]);
            if (file.isDirectory()) {
                process(file);
            } else {
                String convertFile = getConvertFile(file.getPath());
                if (isSuportedFile(convertFile)) {
                    convertFile = replaceExtension(convertFile);
                    new File(new File(convertFile).getParent()).mkdirs();
                    try {
                        System.out.print(convertFile);
                        convert(file.getPath(), convertFile);
                        System.out.println(" [OK] ");
                    } catch (Exception e) {
                        System.out.println(convertFile + " [FAILED] ");
                        System.out.println(" ********** REASON: " + e.getClass().getName() + " ********** ");
                    } catch (OutOfMemoryError e) {
                        System.out.println(convertFile + "  [FAILED]  ");
                        System.out.println(" ********** REASON: OutOfMemoryError ********** ");
                    }
                }
            }
            fileNames[i] = null;
        }
    }

    private String getConvertFile(String path) {
        String convertPath = (destinationFolder + path.substring(sourceFolder.length()));
        return convertPath;
    }

    private boolean isSuportedFile(String path) {
        return (path.endsWith(".gp3") || path.endsWith(".gp4"));
    }

    private String replaceExtension(String path) {
        if (path.endsWith(".gp3") || path.endsWith(".gp4")) {
            path = path.replaceAll(".gp3", ".tg");
            path = path.replaceAll(".gp4", ".tg");
        }
        return path;
    }

    private void writeSong(String fileName, Song song) {
        try {
            new TGOutputStream(fileName).write(song);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
    
    
    
    
    public static void main(String args[]) {
        if(args.length >= 2){ 
            String sourceFolder = args[0];
            String destinationFolder = args[1];
            
            TGConverter converter = new TGConverter(sourceFolder,destinationFolder);
            File initFolder = new File(sourceFolder);
            converter.process(initFolder);
        }else{
            showHelp();
        }
    }

    private static void showHelp(){
        System.out.println("usage options:  [SOURCE FOLDER] [DESTINATION FOLDER]");
    }
        

}