/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.items.ItemContainer;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FileMenuItem implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private MenuItem fileMenuItem;
    private Menu menu;
    private MenuItem newSong;
    private MenuItem open;
    private MenuItem save;
    private MenuItem importFile;
    private MenuItem exit;
    private MenuItem dotted;
    private MenuItem tupleto;
    
    public FileMenuItem(Shell shell,Menu parent, int style, TablatureEditor tablatureEditor) {
        this.fileMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //---------------------------------------------------
        //--NEW--
        this.newSong = new MenuItem(this.menu, SWT.PUSH);
        this.newSong.setImage(new Image(this.menu.getDisplay(), TuxGuitar.getResourcePath(this, "new.png")));
        this.newSong.setText("&New");
        this.newSong.addSelectionListener(TuxGuitar.instance().getAction(NewFileAction.NAME));
        //--OPEN--
        this.open = new MenuItem(this.menu, SWT.PUSH);
        this.open.setImage(new Image(this.menu.getDisplay(), TuxGuitar.getResourcePath(this, "open.png")));
        this.open.setText("&Open");
        this.open.addSelectionListener(TuxGuitar.instance().getAction(OpenFileAction.NAME)); 
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--SAVE--
        this.save = new MenuItem(this.menu, SWT.PUSH);
        this.save.setImage(new Image(this.menu.getDisplay(), TuxGuitar.getResourcePath(this, "save.png")));
        this.save.setText("&Save");
        this.save.addSelectionListener(TuxGuitar.instance().getAction(SaveFileAction.NAME));        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--EXIT--
        this.exit = new MenuItem(this.menu, SWT.PUSH);
        this.exit.setText("&Exit");
        this.exit.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                tablatureEditor.getTablature().dispose();
                tablatureEditor.getSongManager().getPlayer().close();
                System.exit(0);
            }
        });
        //---------------------------------------------------

        this.fileMenuItem.setText("&File");
        this.fileMenuItem.setMenu(menu);
    }

    
    public void update(){
        
    }
}