/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.song.models.InstrumentString;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTunningTrackAction extends Action {
    public static final String NAME = "CHANGE_TUNNING_TRACK";
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[MAX_STRINGS];
    private int stringCount;

    public ChangeTunningTrackAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        if (trackCoords != null) {
            this.stringCount = trackCoords.getTrack().getStrings().size();
            this.initTempStirngs(trackCoords.getTrack().getStrings());

            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
            GridLayout layout = new GridLayout(MAX_STRINGS, true);
            layout.verticalSpacing = 40;
            layout.horizontalSpacing = 0;
            dialog.setLayout(layout);


            //------------Tunning-------------------------------------
            String[] tunningTexts = getAllValueNames();
            for (int i = 0; i < MAX_STRINGS; i++) {
                stringSpinners[i] = new TunningSpinner(dialog, SWT.NONE);
                stringSpinners[i].setTexts(tunningTexts);
            }
            updateTunningSpinner();                        
            
            //------------String Count-------------------------------------
            Label stringCountLabel = new Label(dialog, SWT.NULL);
            stringCountLabel.setText("Strings:");
            final Spinner stringCountSpinner = new Spinner(dialog, SWT.BORDER);
            GridData stringCountSpinnerData = new GridData(40,15);
            stringCountSpinnerData.horizontalSpan = 4;
            stringCountSpinner.setLayoutData(stringCountSpinnerData);
            
            stringCountSpinner.setMinimum(MIN_STRINGS);
            stringCountSpinner.setMaximum(MAX_STRINGS);
            stringCountSpinner.setSelection(this.stringCount);
            stringCountSpinner.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {                    
                    stringCount = stringCountSpinner.getSelection();
                    setDefaultTunning();
                    updateTunningSpinner();
                }
            });            
            
            //------------button ok-cancel--------------------------------------
            final Button buttonOK = new Button(dialog, SWT.PUSH);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    changeInstrumentStrings();
                    
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(dialog, SWT.PUSH);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    private void changeInstrumentStrings(){
        int stringNumber = 1;
        List strings = new ArrayList();
        for (int i = stringCount -1; i >= 0; i--) {
            strings.add(new InstrumentString(stringNumber,stringSpinners[i].getSelection()));
            stringNumber++;
        }         
        
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        trackCoords.changeInstrumentStrings(strings);
        //trackCoords.getTrack().setStrings(strings);
        
        
        new SyncThread(getEditor(), new Runnable() {
            public void run() {
                updateTablature();
                redraw();                
            }
        }).start();        
        
    }
    
    
        
    
    
    private void updateTunningSpinner() {
        int spinnerIndex = tempStrings.size() - 1 ;
        Iterator it = tempStrings.iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            stringSpinners[spinnerIndex].setSelection(string.getValue());
            stringSpinners[spinnerIndex].setVisible(true);
            spinnerIndex --;           
        }
        for (int i = tempStrings.size(); i < MAX_STRINGS; i++) {
            stringSpinners[i].setSelection(0);
            stringSpinners[i].setVisible(false);
        }
    }

    private void initTempStirngs(List realStrings) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < realStrings.size(); i++) {
            InstrumentString realString = (InstrumentString) realStrings.get(i);
            tempStrings.add(realString.clone());
        }
    }

    
    
    private void setDefaultTunning() {
        this.tempStrings.clear();

        switch (stringCount) {
        case 7:
            this.tempStrings.add(new InstrumentString(1, 64));
            this.tempStrings.add(new InstrumentString(2, 59));
            this.tempStrings.add(new InstrumentString(3, 55));
            this.tempStrings.add(new InstrumentString(4, 50));
            this.tempStrings.add(new InstrumentString(5, 45));
            this.tempStrings.add(new InstrumentString(6, 40));
            this.tempStrings.add(new InstrumentString(7, 35));
            break;
        case 6:
            this.tempStrings.add(new InstrumentString(1, 64));
            this.tempStrings.add(new InstrumentString(2, 59));
            this.tempStrings.add(new InstrumentString(3, 55));
            this.tempStrings.add(new InstrumentString(4, 50));
            this.tempStrings.add(new InstrumentString(5, 45));
            this.tempStrings.add(new InstrumentString(6, 40));
            break;
        case 5:
            this.tempStrings.add(new InstrumentString(1, 43));
            this.tempStrings.add(new InstrumentString(2, 38));
            this.tempStrings.add(new InstrumentString(3, 33));
            this.tempStrings.add(new InstrumentString(4, 28));
            this.tempStrings.add(new InstrumentString(5, 23));
            break;
        case 4:
            this.tempStrings.add(new InstrumentString(1, 43));
            this.tempStrings.add(new InstrumentString(2, 38));
            this.tempStrings.add(new InstrumentString(3, 33));
            this.tempStrings.add(new InstrumentString(4, 28));
            break;
        }

    }

    
    
    private String[] getAllValueNames(){
        String[] valueNames = new String[MAX_NOTES * MAX_OCTAVES];
        for(int i = 0;i < valueNames.length;i++){
            valueNames[i] = getValueName(i);
        }
        
        return valueNames;
    }
    
    private String getValueName(int value){
        String name = null;        
        int octave = (value / MAX_NOTES);
        value = value - (octave * MAX_NOTES);        
        switch(value){
        	case 0:
        	    name = "C";
        	    break;
        	case 1:
        	    name = "C#";
        	    break;        
        	case 2:
        	    name = "D";
        	    break;
        	case 3:
        	    name = "D#";
        	    break;
        	case 4:
        	    name = "E";
        	    break;
        	case 5:
        	    name = "F";
        	    break;
        	case 6:
        	    name = "F#";
        	    break;
        	case 7:
        	    name = "G";
        	    break;
        	case 8:
        	    name = "G#";
        	    break;
        	case 9:
        	    name = "A";
        	    break;
        	case 10:
        	    name = "Bb";
        	    break;     	    
        	case 11:
        	    name = "B";
        	    break;            
        }        
        return name + octave;
    }
    
    
    private class TunningSpinner extends Composite{
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;
        
        public TunningSpinner(Composite parent, int style) {
            super(parent, style);            
            this.setLayout(createLayout(2));
            this.init();
        }
        
        
        private void init(){
            this.text = new Text(this,SWT.BORDER);     
            this.text.setLayoutData(new GridData(30,22));            
            this.buttonComposite = new Composite(this,SWT.NONE);
            this.buttonComposite.setLayout(createLayout(1));
            this.upButton = new Button(buttonComposite,SWT.ARROW | SWT.UP);
            this.upButton.setLayoutData(new GridData(15,15));
            this.downButton = new Button(buttonComposite,SWT.ARROW | SWT.DOWN);
            this.downButton.setLayoutData(new GridData(15,15));                        
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;
            
            this.text.setEditable(false);
            
            this.upButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    setSelection(selection + 1);
                }
            });
            
            this.downButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    setSelection(selection - 1);
                }
            });                      
        }
        
        private Layout createLayout(int numColumns){
            GridLayout layout = new GridLayout(numColumns,false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;     
            return layout;
        }
        
        public void setTexts(String[] texts){
            this.texts = texts;
            this.minSelection = 0;
            this.maxSelection = texts.length - 1;
        }        

        public int getSelection() {
            return selection;
        }
        
        public void setSelection(int selection) {
            if(selection >= minSelection && selection <= maxSelection){            
                this.selection = selection;
            	if(texts != null){
                	this.text.setText(texts[selection]);
            	}            
            }
        }
    }
        
}