/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    Tree parent;
    Font font;
    Font[] cellFont;
    boolean cached;
    boolean grayed;
    static final int EXPANDER_EXTRA_PADDING = 4;

    public TreeItem(Tree parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, 0, -1);
    }

    public TreeItem(Tree parent, int style, int index) {
        super(parent, style);
        if (index < 0) {
            this.error(6);
        }
        this.parent = parent;
        parent.createItem(this, 0, index);
    }

    public TreeItem(TreeItem parentItem, int style) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        this.parent = parentItem.parent;
        this.parent.createItem(this, parentItem.handle, -1);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        super(TreeItem.checkNull((TreeItem)parentItem).parent, style);
        if (index < 0) {
            this.error(14);
        }
        this.parent = parentItem.parent;
        this.parent.createItem(this, parentItem.handle, index);
    }

    static TreeItem checkNull(TreeItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 4, ptr, -1);
        if (ptr[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 3, ptr, -1);
        if (ptr[0] == 0) {
            return this.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Rectangle getBounds(int index) {
        int parentHandle;
        int column;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((column = OS.gtk_tree_view_get_column(parentHandle = this.parent.handle, index)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        if (OS.gtk_tree_view_get_expander_column(parentHandle) == column) {
            int[] buffer = new int[1];
            OS.gtk_widget_style_get(parentHandle, OS.expander_size, buffer, 0);
            rect.x += buffer[0] + 4;
            rect.width -= buffer[0] + 4;
            OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
            rect.x += buffer[0];
        }
        if (index == 0 && (this.parent.style & 0x20) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
                int[] x = new int[1];
                int[] w = new int[1];
                OS.gtk_tree_view_column_cell_get_position(column, this.parent.checkRenderer, x, w);
                rect.x += x[0] + w[0];
                rect.width -= x[0] + w[0];
            } else {
                int[] w = new int[1];
                OS.gtk_cell_renderer_get_size(this.parent.checkRenderer, parentHandle, null, null, null, w, null);
                int[] buffer = new int[1];
                OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
                rect.x += w[0] + buffer[0];
                rect.width -= w[0] + buffer[0];
            }
        }
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords(parentHandle, rect.x, 0, wx, null);
        rect.x = wx[0];
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + (index == 0 ? 0 : border), rect.y + (headerHeight == 0 ? border : headerHeight), rect.width + 1, rect.height + 1);
    }

    public Rectangle getBounds() {
        int parentHandle;
        int column;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((column = OS.gtk_tree_view_get_column(parentHandle = this.parent.handle, 0)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int textRenderer = this.parent.getTextRenderer(column);
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (textRenderer == 0 || pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        boolean isExpander = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean isExpanded = OS.gtk_tree_view_row_expanded(parentHandle, path);
        OS.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, isExpander, isExpanded);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        int[] x = new int[1];
        int[] w = new int[1];
        OS.gtk_cell_renderer_get_size(textRenderer, parentHandle, null, null, null, w, null);
        rect.width = w[0];
        int[] buffer = new int[1];
        if (OS.gtk_tree_view_get_expander_column(parentHandle) == column) {
            OS.gtk_widget_style_get(parentHandle, OS.expander_size, buffer, 0);
            rect.x += buffer[0] + 4;
        }
        OS.gtk_widget_style_get(parentHandle, OS.horizontal_separator, buffer, 0);
        int horizontalSeparator = buffer[0];
        rect.x += horizontalSeparator;
        if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
            OS.gtk_tree_view_column_cell_get_position(column, textRenderer, x, null);
            rect.x += x[0];
        } else {
            if ((this.parent.style & 0x20) != 0) {
                OS.gtk_cell_renderer_get_size(this.parent.checkRenderer, parentHandle, null, null, null, w, null);
                rect.x += w[0] + horizontalSeparator;
            }
            OS.gtk_cell_renderer_get_size(pixbufRenderer, parentHandle, null, null, null, w, null);
            rect.x += w[0] + horizontalSeparator;
        }
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords(parentHandle, rect.x, 0, wx, null);
        rect.x = wx[0];
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + border, rect.y + (headerHeight == 0 ? border : headerHeight), rect.width + 1, rect.height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, ptr, -1);
        return ptr[0] != 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        boolean answer = OS.gtk_tree_view_row_expanded(this.parent.handle, path);
        OS.gtk_tree_path_free(path);
        return answer;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, ptr, -1);
        if (ptr[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 2, ptr, -1);
        if (ptr[0] == 0) {
            return this.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, ptr[0], GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index > this.parent.columnCount) {
            return null;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return null;
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 0, ptr, -1);
        if (ptr[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int imageIndex = imageList.indexOf(ptr[0]);
        if (imageIndex == -1) {
            return null;
        }
        return imageList.get(imageIndex);
    }

    public Rectangle getImageBounds(int index) {
        int parentHandle;
        int column;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((column = OS.gtk_tree_view_get_column(parentHandle = this.parent.handle, index)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int pixbufRenderer = this.parent.getPixbufRenderer(column);
        if (pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(parentHandle);
        OS.gtk_tree_view_get_cell_area(parentHandle, path, column, rect);
        OS.gtk_tree_path_free(path);
        if (OS.gtk_tree_view_get_expander_column(parentHandle) == column) {
            int[] buffer = new int[1];
            OS.gtk_widget_style_get(parentHandle, OS.expander_size, buffer, 0);
            rect.x += buffer[0] + 4;
            rect.width -= buffer[0] + 4;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 1, 3)) {
            int[] x = new int[1];
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_get_position(column, pixbufRenderer, x, w);
            rect.x += x[0];
            rect.width = w[0];
        } else {
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_set_cell_data(column, this.parent.modelHandle, this.handle, false, false);
            OS.gtk_cell_renderer_get_size(pixbufRenderer, parentHandle, null, null, null, w, null);
            rect.width = w[0];
        }
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords(parentHandle, rect.x, 0, wx, null);
        rect.x = wx[0];
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + (index == 0 ? 0 : border), rect.y + (headerHeight == 0 ? border : headerHeight), rect.width, rect.height + 1);
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        int length = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
        if (index < 0 || index >= length) {
            this.error(6);
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.parent.modelHandle, iter, this.handle, index);
        int[] value = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, iter, 0, value, -1);
        TreeItem item = this.parent.items[value[0]];
        OS.g_free(iter);
        return item;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.parent.getItems(this.handle);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        TreeItem item = null;
        if (OS.gtk_tree_path_get_depth(path) > 1) {
            OS.gtk_tree_path_up(path);
            int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(this.parent.modelHandle, iter, path)) {
                int[] index = new int[1];
                OS.gtk_tree_model_get(this.parent.modelHandle, iter, 0, index, -1);
                item = this.parent.items[index[0]];
            }
            OS.g_free(iter);
        }
        OS.gtk_tree_path_free(path);
        return item;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index > this.parent.columnCount) {
            return "";
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            this.error(12);
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 1, ptr, -1);
        if (ptr[0] == 0) {
            return "";
        }
        int length = OS.strlen(ptr[0]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr[0], length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public int indexOf(TreeItem item) {
        int indices;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        boolean isParent = false;
        int currentPath = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        int parentPath = OS.gtk_tree_model_get_path(this.parent.modelHandle, item.handle);
        int depth = OS.gtk_tree_path_get_depth(parentPath);
        if (depth > 1 && OS.gtk_tree_path_up(parentPath) && OS.gtk_tree_path_compare(currentPath, parentPath) == 0) {
            isParent = true;
        }
        OS.gtk_tree_path_free(currentPath);
        OS.gtk_tree_path_free(parentPath);
        if (!isParent) {
            return index;
        }
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, item.handle);
        if (depth > 1 && (indices = OS.gtk_tree_path_get_indices(path)) != 0) {
            int[] temp = new int[depth];
            OS.memmove(temp, indices, 4 * temp.length);
            index = temp[temp.length - 1];
        }
        OS.gtk_tree_path_free(path);
        return index;
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.handle != 0) {
            OS.g_free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
        this.font = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        int length = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
        if (length == 0) {
            return;
        }
        int iter = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int[] index = new int[1];
        while (OS.gtk_tree_model_iter_children(this.parent.modelHandle, iter, this.handle)) {
            OS.gtk_tree_model_get(this.parent.modelHandle, iter, 0, index, -1);
            TreeItem item = this.parent.items[index[0]];
            if (item == null || item.isDisposed()) continue;
            item.dispose();
        }
        OS.g_free(iter);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 4, gdkColor, -1);
        this.cached = true;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 3, gdkColor, -1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.textCellDataProc, this.parent.handle, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.pixbufCellDataProc, this.parent.handle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 1, checked, -1);
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, !checked ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        int path = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        if (expanded) {
            OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0, 0, 44);
            OS.gtk_tree_view_expand_row(this.parent.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0, 0, 44);
        } else {
            OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0, 0, 43);
            OS.gtk_widget_realize(this.parent.handle);
            OS.gtk_tree_view_collapse_row(this.parent.handle, path);
            OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0, 0, 43);
        }
        OS.gtk_tree_path_free(path);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (this.font != null && this.font.equals(font)) {
            return;
        }
        this.font = font;
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 5, fontHandle, -1);
        this.cached = true;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.cellFont == null) {
            this.cellFont = new Font[count];
        }
        if (this.cellFont[index] == font) {
            return;
        }
        if (this.cellFont[index] != null && this.cellFont[index].equals(font)) {
            return;
        }
        this.cellFont[index] = font;
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 4, fontHandle, -1);
        this.cached = true;
        if (font != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.textCellDataProc, this.parent.handle, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.pixbufCellDataProc, this.parent.handle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 3, gdkColor, -1);
        this.cached = true;
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 2, gdkColor, -1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int textRenderer = this.parent.getTextRenderer(column);
                    int imageRenderer = this.parent.getPixbufRenderer(column);
                    OS.gtk_tree_view_column_set_cell_data_func(column, textRenderer, this.display.textCellDataProc, this.parent.handle, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(column, imageRenderer, this.display.pixbufCellDataProc, this.parent.handle, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        int[] ptr = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, ptr, -1);
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, ptr[0] == 0 ? false : grayed, -1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (index < 0 || index > this.parent.columnCount) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return;
        }
        int pixbuf = 0;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 0, pixbuf, -1);
        this.cached = true;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.parent.columnCount) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column(parentHandle, index);
        if (column == 0) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int modelIndex = this.parent.columnCount == 0 ? 6 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, modelIndex + 1, buffer, -1);
        this.cached = true;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }
}

