/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    int defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        int type = (this.style & 0x200) != 0 ? 108 : 116;
        this.defaultCursor = OS.gdk_cursor_new(type);
    }

    void drawBand(int x, int y, int width, int height) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        int window = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        if (window == 0) {
            return;
        }
        byte[] bits = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int stipplePixmap = OS.gdk_bitmap_create_from_data(window, bits, 8, 8);
        int gc = OS.gdk_gc_new(window);
        int colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white(colormap, color);
        OS.gdk_gc_set_foreground(gc, color);
        OS.gdk_gc_set_stipple(gc, stipplePixmap);
        OS.gdk_gc_set_subwindow(gc, 1);
        OS.gdk_gc_set_fill(gc, 2);
        OS.gdk_gc_set_function(gc, 2);
        OS.gdk_draw_rectangle(window, gc, 1, x, y, width, height);
        OS.g_object_unref(stipplePixmap);
        OS.g_object_unref(gc);
    }

    int gtk_button_press_event(int widget, int eventPtr) {
        int result = super.gtk_button_press_event(widget, eventPtr);
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0;
        }
        if (gdkEvent.type == 5) {
            return 0;
        }
        if (gdkEvent.type == 6) {
            return 0;
        }
        int window = OS.GTK_WIDGET_WINDOW(widget);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        this.startX = (int)(gdkEvent.x_root - (double)origin_x[0]);
        this.startY = (int)(gdkEvent.y_root - (double)origin_y[0]);
        int x = OS.GTK_WIDGET_X(this.handle);
        int y = OS.GTK_WIDGET_Y(this.handle);
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        this.lastX = x;
        this.lastY = y;
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            this.parent.update(true);
            this.drawBand(event.x, event.y, width, height);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, width, height);
            }
        }
        return result;
    }

    int gtk_button_release_event(int widget, int eventPtr) {
        int result = super.gtk_button_release_event(widget, eventPtr);
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0;
        }
        if (!this.dragging) {
            return 0;
        }
        this.dragging = false;
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.drawBand(this.lastX, this.lastY, width, height);
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return result;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, width, height);
        }
        return result;
    }

    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        if (result != 0) {
            return result;
        }
        if (this.handle != 0) {
            this.lastX = OS.GTK_WIDGET_X(this.handle);
            this.lastY = OS.GTK_WIDGET_Y(this.handle);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int eventPtr) {
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
        int keyval = gdkEvent.keyval;
        switch (keyval) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                if ((gdkEvent.state & 4) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyval == 65362 || keyval == 65364) break;
                    xChange = keyval == 65361 ? -stepSize : stepSize;
                } else {
                    if (keyval == 65361 || keyval == 65363) break;
                    yChange = keyval == 65362 ? -stepSize : stepSize;
                }
                int width = OS.GTK_WIDGET_WIDTH(this.handle);
                int height = OS.GTK_WIDGET_HEIGHT(this.handle);
                int parentBorder = 0;
                int parentWidth = OS.GTK_WIDGET_WIDTH(this.parent.handle);
                int parentHeight = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange - parentBorder - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange - parentBorder - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                int window = OS.GTK_WIDGET_WINDOW(this.handle);
                int grabMask = 516;
                int gdkCursor = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int ptrGrabResult = OS.gdk_pointer_grab(window, false, grabMask, window, gdkCursor, 0);
                Event event = new Event();
                event.time = gdkEvent.time;
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (ptrGrabResult == 0) {
                    OS.gdk_pointer_ungrab(0);
                }
                if (this.isDisposed() || !event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if ((this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, width, height);
                    if (this.isDisposed()) break;
                }
                int cursorX = event.x;
                int cursorY = event.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    int gtk_motion_notify_event(int widget, int eventPtr) {
        int eventState;
        int eventY;
        int eventX;
        int result = super.gtk_motion_notify_event(widget, eventPtr);
        if (!this.dragging) {
            return 0;
        }
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        if (gdkEvent.is_hint != 0) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            int[] mask = new int[1];
            OS.gdk_window_get_pointer(gdkEvent.window, pointer_x, pointer_y, mask);
            eventX = pointer_x[0];
            eventY = pointer_y[0];
            eventState = mask[0];
        } else {
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            OS.gdk_window_get_origin(gdkEvent.window, origin_x, origin_y);
            eventX = (int)(gdkEvent.x_root - (double)origin_x[0]);
            eventY = (int)(gdkEvent.y_root - (double)origin_y[0]);
            eventState = gdkEvent.state;
        }
        if ((eventState & 0x100) == 0) {
            return 0;
        }
        int x = OS.GTK_WIDGET_X(this.handle);
        int y = OS.GTK_WIDGET_Y(this.handle);
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        int parentBorder = 0;
        int parentWidth = OS.GTK_WIDGET_WIDTH(this.parent.handle);
        int parentHeight = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, eventX + x - this.startX - parentBorder), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, eventY + y - this.startY - parentBorder), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return 0;
        }
        this.drawBand(this.lastX, this.lastY, width, height);
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = newX;
        event.y = newY;
        event.width = width;
        event.height = height;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
        }
        this.parent.update(true);
        this.drawBand(this.lastX, this.lastY, width, height);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(this.lastX, this.lastY, width, height);
        }
        return result;
    }

    int gtk_realize(int widget) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0);
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.gtk_widget_add_events(this.handle, 8);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0) {
            OS.gdk_cursor_destroy(this.defaultCursor);
        }
        this.defaultCursor = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void setCursor(int cursor) {
        super.setCursor(cursor != 0 ? cursor : this.defaultCursor);
    }

    int traversalCode(int key, GdkEventKey event) {
        return 0;
    }
}

