/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg.old;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.io.tg.old.TGFormat;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TGLoader {
    public static Song openSong(String fileName) {
        File file = new File(fileName);
        Document doc = TGLoader.getDocument(file);
        return TGLoader.readSong(doc.getFirstChild());
    }

    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    private static Song readSong(Node node) {
        ArrayList<SongTrack> tracks = new ArrayList<SongTrack>();
        String name = "";
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_NAME)) {
                name = TGLoader.readValue(child);
            } else if (nodeName.equals(TGFormat.MODEL_TRACK)) {
                tracks.add(TGLoader.readTrack(child));
            }
            ++i;
        }
        return new Song(name, tracks);
    }

    private static SongTrack readTrack(Node node) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>();
        int channel = 0;
        int instrument = 0;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_CHANNEL)) {
                channel = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_INSTRUMENT)) {
                instrument = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_MEASURE)) {
                measures.add(TGLoader.readMeasure(child));
            } else if (nodeName.equals(TGFormat.MODEL_INSTRUMENTSTRING)) {
                strings.add(TGLoader.readInstrumentString(child));
            }
            ++i;
        }
        return new SongTrack(channel, instrument, measures, strings);
    }

    private static Measure readMeasure(Node node) {
        ArrayList<Note> notes = new ArrayList<Note>();
        ArrayList<Silence> silences = new ArrayList<Silence>();
        TimeSignature timeSignature = null;
        Tempo tempo = null;
        long start = 0L;
        boolean repeatStart = false;
        int numberOfRepetitions = 0;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_START)) {
                start = Long.parseLong(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_REPEATSTART)) {
                repeatStart = Boolean.valueOf(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_NUMBEROFREPETITIONS)) {
                numberOfRepetitions = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_NOTE)) {
                notes.add(TGLoader.readNote(child));
            } else if (nodeName.equals(TGFormat.MODEL_SILENCE)) {
                silences.add(TGLoader.readSilence(child));
            } else if (nodeName.equals(TGFormat.MODEL_TIMESIGNATURE)) {
                timeSignature = TGLoader.readTimeSignature(child);
            } else if (nodeName.equals(TGFormat.MODEL_TEMPO)) {
                tempo = TGLoader.readTempo(child);
            }
            ++i;
        }
        return new Measure(start, notes, silences, timeSignature, tempo, repeatStart, numberOfRepetitions);
    }

    private static Note readNote(Node node) {
        int value = 0;
        long start = 0L;
        Duration duration = null;
        int velocity = 0;
        InstrumentString string = null;
        boolean tiedNote = false;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_START)) {
                start = Long.parseLong(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_VELOCITY)) {
                velocity = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_TIEDNOTE)) {
                tiedNote = Boolean.valueOf(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_DURATION)) {
                duration = TGLoader.readDuration(child);
            } else if (nodeName.equals(TGFormat.MODEL_INSTRUMENTSTRING)) {
                string = TGLoader.readInstrumentString(child);
            }
            ++i;
        }
        return new Note(value, start, duration, velocity, string.getNumber(), tiedNote);
    }

    private static Silence readSilence(Node node) {
        long start = 0L;
        Duration duration = null;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_START)) {
                start = Long.parseLong(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_DURATION)) {
                duration = TGLoader.readDuration(child);
            }
            ++i;
        }
        return new Silence(start, duration);
    }

    private static InstrumentString readInstrumentString(Node node) {
        int number = 0;
        int value = 0;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_NUMBER)) {
                number = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(TGLoader.readValue(child));
            }
            ++i;
        }
        return new InstrumentString(number, value);
    }

    private static Tempo readTempo(Node node) {
        int value = 0;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(TGLoader.readValue(child));
            }
            ++i;
        }
        return new Tempo(value);
    }

    private static TimeSignature readTimeSignature(Node node) {
        Duration denominator = null;
        int numerator = 0;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_NUMERATOR)) {
                numerator = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_DURATION)) {
                denominator = TGLoader.readDuration(child);
            }
            ++i;
        }
        return new TimeSignature(numerator, denominator);
    }

    private static Duration readDuration(Node node) {
        int value = 0;
        boolean dotted = false;
        Tupleto tupleto = null;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_VALUE)) {
                value = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_DOTTED)) {
                dotted = Boolean.valueOf(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.MODEL_TUPLETO)) {
                tupleto = TGLoader.readTupleto(child);
            }
            ++i;
        }
        return new Duration(value, dotted, tupleto);
    }

    private static Tupleto readTupleto(Node node) {
        int enters = 0;
        int times = 0;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equals(TGFormat.PARAM_ENTERS)) {
                enters = Integer.parseInt(TGLoader.readValue(child));
            } else if (nodeName.equals(TGFormat.PARAM_TIMES)) {
                times = Integer.parseInt(TGLoader.readValue(child));
            }
            ++i;
        }
        return new Tupleto(enters, times);
    }

    private static String readValue(Node node) {
        Node child = node.getFirstChild();
        return child.getNodeValue();
    }
}

