/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

public class TGOutputStream {
    private static final String TG_VERSION = "TG_DEVEL-0.01";
    private DataOutputStream dataOutputStream;

    public TGOutputStream(FileOutputStream file) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(file);
    }

    public TGOutputStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(new File(fileName)));
    }

    public void write(Song song) {
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeVersion() {
        this.writeString(TG_VERSION);
    }

    private void writeSong(Song song) {
        this.writeString(song.getName());
        this.writeInt(song.getTracks().size());
        Iterator it = song.getTracks().iterator();
        while (it.hasNext()) {
            SongTrack track = (SongTrack)it.next();
            this.writeTrack(track);
        }
    }

    private void writeTrack(SongTrack track) {
        this.writeInt(track.getChannel());
        this.writeInt(track.getInstrument());
        this.writeInt(track.getMeasures().size());
        Iterator measureIt = track.getMeasures().iterator();
        while (measureIt.hasNext()) {
            Measure measure = (Measure)measureIt.next();
            this.writeMeasure(measure);
        }
        this.writeInt(track.getStrings().size());
        Iterator stringIt = track.getStrings().iterator();
        while (stringIt.hasNext()) {
            InstrumentString string = (InstrumentString)stringIt.next();
            this.writeInstrumentString(string);
        }
    }

    private void writeMeasure(Measure measure) {
        this.writeLong(measure.getStart());
        this.writeInt(measure.getNotes().size());
        Iterator noteIt = measure.getNotes().iterator();
        while (noteIt.hasNext()) {
            Note note = (Note)noteIt.next();
            this.writeNote(note);
        }
        this.writeInt(measure.getSilences().size());
        Iterator silenceIt = measure.getSilences().iterator();
        while (silenceIt.hasNext()) {
            Silence silence = (Silence)silenceIt.next();
            this.writeSilence(silence);
        }
        this.writeTimeSignature(measure.getTimeSignature());
        this.writeTempo(measure.getTempo());
        this.writeBoolean(measure.isRepeatStart());
        this.writeInt(measure.getNumberOfRepetitions());
    }

    private void writeNote(Note note) {
        this.writeInt(note.getValue());
        this.writeLong(note.getStart());
        this.writeDuration(note.getDuration());
        this.writeInt(note.getVelocity());
        this.writeInt(note.getString());
        this.writeBoolean(note.isTiedNote());
    }

    private void writeSilence(Silence silence) {
        this.writeLong(silence.getStart());
        this.writeDuration(silence.getDuration());
    }

    private void writeInstrumentString(InstrumentString string) {
        this.writeInt(string.getNumber());
        this.writeInt(string.getValue());
    }

    private void writeTempo(Tempo tempo) {
        this.writeInt(tempo.getValue());
    }

    private void writeTimeSignature(TimeSignature timeSignature) {
        this.writeInt(timeSignature.getNumerator());
        this.writeDuration(timeSignature.getDenominator());
    }

    private void writeDuration(Duration duration) {
        this.writeInt(duration.getValue());
        this.writeBoolean(duration.isDotted());
        this.writeTupleto(duration.getTupleto());
    }

    private void writeTupleto(Tupleto tupleto) {
        this.writeInt(tupleto.getEnters());
        this.writeInt(tupleto.getTimes());
    }

    private void writeString(String v) {
        try {
            this.dataOutputStream.write(v.length());
            this.dataOutputStream.writeChars(v);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeInt(int v) {
        try {
            this.dataOutputStream.writeInt(v);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeLong(long v) {
        try {
            this.dataOutputStream.writeLong(v);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeBoolean(boolean v) {
        try {
            this.dataOutputStream.writeBoolean(v);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

