/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class GP4InputStream
extends InputStream {
    private static final String[] supportedVersions = new String[]{"FICHIER GUITAR PRO v4.00", "FICHIER GUITAR PRO v4.06", "FICHIER GUITAR PRO L4.06"};
    private InputStream inputStream;
    private int offset;

    public GP4InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.offset = 0;
    }

    public GP4InputStream(String fileName) throws FileNotFoundException {
        this(new FileInputStream(new File(fileName)));
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public int read() throws IOException {
        ++this.offset;
        return this.inputStream.read();
    }

    public static boolean isSupportedVersion(String version) {
        int i = 0;
        while (i < supportedVersions.length) {
            if (version.equals(supportedVersions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Song readSong() throws IOException, GPFormatException {
        String version = this.readStringByte(30);
        if (!GP4InputStream.isSupportedVersion(version)) {
            throw new GPFormatException("Unsuported Version");
        }
        String title = this.readStringIntegerPlusOne();
        String subtitle = this.readStringIntegerPlusOne();
        String interpret = this.readStringIntegerPlusOne();
        String album = this.readStringIntegerPlusOne();
        String songAuthor = this.readStringIntegerPlusOne();
        String copyright = this.readStringIntegerPlusOne();
        String pieceAuthor = this.readStringIntegerPlusOne();
        String instructions = this.readStringIntegerPlusOne();
        int nbNotes = this.readInt();
        String note = "";
        int i = 0;
        while (i < nbNotes) {
            note = String.valueOf(note) + this.readStringIntegerPlusOne();
            note = String.valueOf(note) + "\n";
            ++i;
        }
        boolean tripletFeel = this.readBoolean();
        int trackNumber = this.readInt();
        int i2 = 0;
        while (i2 < 5) {
            int measureNumber = this.readInt();
            String string = this.readStringInteger();
            ++i2;
        }
        int tempoValue = this.readInt();
        byte key = this.readByte();
        int octave = this.readInt();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        int[] instruments = new int[64];
        int i3 = 0;
        while (i3 < 64) {
            channels.add(new Channel(i3, this.readInt(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte()));
            byte[] b = new byte[2];
            this.read(b);
            ++i3;
        }
        Tempo tempo = new Tempo(tempoValue);
        TimeSignature timeSignature = new TimeSignature(4, new Duration(4));
        int numberOfMeasures = this.readInt();
        int numberOfTracks = this.readInt();
        ArrayList<Measure> measures = new ArrayList<Measure>();
        if (numberOfMeasures > 0) {
            int i4 = 0;
            while (i4 < numberOfMeasures) {
                Measure measure = this.createMeasure(timeSignature);
                measures.add(measure);
                ++i4;
            }
        }
        ArrayList<SongTrack> tracks = new ArrayList<SongTrack>();
        int i5 = 0;
        while (i5 < numberOfTracks) {
            tracks.add(this.createTrack(tracks, channels));
            ++i5;
        }
        long nextMeasureStart = 1000L;
        int i6 = 0;
        while (i6 < numberOfMeasures) {
            Measure currMeasure = (Measure)measures.get(i6);
            currMeasure.setStart(nextMeasureStart);
            int j = 0;
            while (j < numberOfTracks) {
                SongTrack track = (SongTrack)tracks.get(j);
                Measure measure = (Measure)currMeasure.clone();
                this.addMeasureComponents(track.getStrings(), measure, track.getMeasures(), tempo);
                measure.setTempo((Tempo)tempo.clone());
                track.getMeasures().add(measure);
                ++j;
            }
            nextMeasureStart += currMeasure.getLength();
            ++i6;
        }
        return new Song(title, tracks);
    }

    private long addNotes(long start, List notes, List trackStrings, List currTrackMeasures, Tempo tempo) throws IOException, GPFormatException {
        int header = this.readUnsignedByte();
        if ((header & 0x40) != 0) {
            int beatStatus = this.readUnsignedByte();
            boolean emptyBeat = beatStatus == 0;
            boolean bl = beatStatus == 2;
        }
        boolean dottedNotes = (header & 1) != 0;
        Duration duration = this.parseDuration(this.readByte());
        duration.setDotted(dottedNotes);
        if ((header & 0x20) != 0) {
            int tuplet = this.readInt();
            switch (tuplet) {
                case 3: {
                    duration.getTupleto().setEnters(3);
                    duration.getTupleto().setTimes(2);
                }
            }
        }
        if ((header & 2) != 0) {
            this.readChordDiagram();
        }
        if ((header & 4) != 0) {
            String tuplet = this.readStringIntegerPlusOne();
        }
        if ((header & 8) != 0) {
            this.readBeatEffects();
        }
        if ((header & 0x10) != 0) {
            this.readMixChange(tempo);
        }
        int stringsPlayed = this.readUnsignedByte();
        List strings = this.getPlayedStrings(stringsPlayed, trackStrings);
        int i = strings.size() - 1;
        while (i >= 0) {
            InstrumentString string = (InstrumentString)strings.get(i);
            Note note = this.parseNote(start, string, duration, notes, currTrackMeasures);
            if (note != null) {
                notes.add(note);
            }
            --i;
        }
        return duration.getTime();
    }

    private List getPlayedStrings(int stringsPlayed, List trackStrings) {
        ArrayList<Object> strings = new ArrayList<Object>();
        if ((stringsPlayed & 1) != 0) {
            strings.add(((InstrumentString)trackStrings.get(6)).clone());
        }
        if ((stringsPlayed & 2) != 0) {
            strings.add(((InstrumentString)trackStrings.get(5)).clone());
        }
        if ((stringsPlayed & 4) != 0) {
            strings.add(((InstrumentString)trackStrings.get(4)).clone());
        }
        if ((stringsPlayed & 8) != 0) {
            strings.add(((InstrumentString)trackStrings.get(3)).clone());
        }
        if ((stringsPlayed & 0x10) != 0) {
            strings.add(((InstrumentString)trackStrings.get(2)).clone());
        }
        if ((stringsPlayed & 0x20) != 0) {
            strings.add(((InstrumentString)trackStrings.get(1)).clone());
        }
        if ((stringsPlayed & 0x40) != 0) {
            strings.add(((InstrumentString)trackStrings.get(0)).clone());
        }
        return strings;
    }

    private Duration parseDuration(byte value) {
        Duration duration = null;
        switch (value) {
            case -2: {
                duration = new Duration(1);
                break;
            }
            case -1: {
                duration = new Duration(2);
                break;
            }
            case 0: {
                duration = new Duration(4);
                break;
            }
            case 1: {
                duration = new Duration(8);
                break;
            }
            case 2: {
                duration = new Duration(16);
                break;
            }
            case 3: {
                duration = new Duration(32);
                break;
            }
            case 4: {
                duration = new Duration(64);
            }
        }
        return duration;
    }

    private int getTiedNoteValue(int string, List notes, List measures) {
        if (!notes.isEmpty()) {
            int nIdx = notes.size() - 1;
            while (nIdx >= 0) {
                Note note = (Note)notes.get(nIdx);
                if (note.getString() == string) {
                    return note.getValue();
                }
                --nIdx;
            }
        }
        if (!measures.isEmpty()) {
            int mIdx = measures.size() - 1;
            while (mIdx >= 0) {
                Measure measure = (Measure)measures.get(mIdx);
                int nIdx = measure.getNotes().size() - 1;
                while (nIdx >= 0) {
                    Note note = (Note)measure.getNotes().get(nIdx);
                    if (note.getString() == string) {
                        return note.getValue();
                    }
                    --nIdx;
                }
                --mIdx;
            }
        }
        return -1;
    }

    private boolean readBoolean() throws IOException {
        return this.read() == 1;
    }

    private byte readByte() throws IOException {
        return (byte)this.read();
    }

    private void readColor() throws IOException {
        int red = this.readUnsignedByte();
        int green = this.readUnsignedByte();
        int blue = this.readUnsignedByte();
        this.read();
    }

    private int readInt() throws IOException {
        int integer = 0;
        byte[] b = new byte[4];
        this.read(b);
        integer = (b[3] & 0xFF) << 24 | (b[2] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[0] & 0xFF;
        return integer;
    }

    private void readMarker() throws IOException {
        String name = this.readStringIntegerPlusOne();
        this.readColor();
    }

    private Measure createMeasure(TimeSignature currTimeSignature) throws IOException {
        boolean doubleBar;
        int header = this.readUnsignedByte();
        byte numerator = 0;
        if ((header & 1) != 0) {
            numerator = this.readByte();
        }
        byte denominator = 0;
        if ((header & 2) != 0) {
            denominator = this.readByte();
        }
        boolean repeatStart = (header & 4) != 0;
        byte numberOfRepetitions = 0;
        if ((header & 8) != 0) {
            numberOfRepetitions = this.readByte();
        }
        byte NumberOfAlternateEnding = 0;
        if ((header & 0x10) != 0) {
            NumberOfAlternateEnding = this.readByte();
        }
        if ((header & 0x20) != 0) {
            this.readMarker();
        }
        if ((header & 0x40) != 0) {
            byte type = this.readByte();
            this.readByte();
        }
        boolean bl = doubleBar = (header & 0x80) != 0;
        if (numerator > 0) {
            currTimeSignature.setNumerator(numerator);
        }
        if (denominator > 0) {
            currTimeSignature.setDenominator(new Duration(denominator));
        }
        return new Measure(0L, new ArrayList(), new ArrayList(), (TimeSignature)currTimeSignature.clone(), new Tempo(120), repeatStart, numberOfRepetitions);
    }

    private void addMeasureComponents(List trackStrings, Measure measure, List currTrackMeasures, Tempo tempo) throws IOException, GPFormatException {
        long nextNoteStart = measure.getStart();
        int numberOfBeats = this.readInt();
        int i = 0;
        while (i < numberOfBeats) {
            nextNoteStart += this.addNotes(nextNoteStart, measure.getNotes(), trackStrings, currTrackMeasures, tempo);
            ++i;
        }
    }

    private Note parseNote(long start, InstrumentString string, Duration currDuration, List currMeasureNotes, List currTrackMeasures) throws IOException {
        byte duration;
        int header = this.readUnsignedByte();
        boolean accentuated = (header & 0x40) != 0;
        boolean dotted = (header & 2) != 0;
        boolean ghostNote = (header & 4) != 0;
        boolean tiedNote = false;
        boolean deadNote = false;
        if ((header & 0x20) != 0) {
            int noteType = this.readUnsignedByte();
            tiedNote = noteType == 2;
            boolean bl = deadNote = noteType == 3;
        }
        if ((header & 1) != 0) {
            duration = this.readByte();
            byte by = this.readByte();
        }
        if ((header & 0x10) != 0) {
            duration = this.readByte();
        }
        int numberOfFret = 0;
        if ((header & 0x20) != 0) {
            numberOfFret = this.readByte();
        }
        if ((header & 0x80) != 0) {
            byte fingeringLeftHand = this.readByte();
            byte by = this.readByte();
        }
        if ((header & 8) != 0) {
            this.readNoteEffects();
        }
        int value = numberOfFret;
        if (numberOfFret >= 0 || tiedNote) {
            if (tiedNote) {
                value = this.getTiedNoteValue(string.getNumber(), currMeasureNotes, currTrackMeasures);
            }
            return new Note(value, start, (Duration)currDuration.clone(), 64, string.getNumber(), tiedNote);
        }
        return null;
    }

    private String readStringByte(int expectedLength) throws IOException {
        int realLength = this.readUnsignedByte();
        byte[] b = expectedLength != 0 ? new byte[expectedLength] : new byte[realLength];
        this.read(b);
        String str = new String(b, 0, realLength);
        return str;
    }

    private String readStringInteger() throws IOException {
        int length = this.readInt();
        byte[] b = new byte[length];
        this.read(b);
        String str = new String(b);
        return str;
    }

    private String readStringIntegerPlusOne() throws IOException {
        int lengthPlusOne = this.readInt();
        int length = lengthPlusOne - 1;
        if (length != this.read()) {
            throw new IOException();
        }
        byte[] b = new byte[length];
        this.read(b);
        String str = new String(b);
        return str;
    }

    private SongTrack createTrack(List tracks, List channels) throws IOException {
        int header = this.readUnsignedByte();
        boolean isDrumsTrack = (header & 1) != 0;
        boolean is12StringedGuitarTrack = (header & 2) != 0;
        boolean isBanjoTrack = (header & 4) != 0;
        String name = this.readStringByte(40);
        int numberOfStrings = this.readInt();
        ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>(numberOfStrings);
        int i = 0;
        while (i < 7) {
            int tunning = this.readInt();
            if (numberOfStrings > i) {
                strings.add(new InstrumentString(i + 1, tunning));
            }
            ++i;
        }
        int port = this.readInt();
        int channelIndex = this.readInt();
        int effects = this.readInt();
        int numberOfFrets = this.readInt();
        int capo = this.readInt();
        this.readColor();
        Channel channel = this.parseChannel(tracks, channels, channelIndex);
        return new SongTrack(channel.getChannel(), channel.getInstrument(), new ArrayList(), strings);
    }

    private Channel parseChannel(List tracks, List channels, int channelIndex) {
        int instrument;
        Channel channel = (Channel)channels.get(channelIndex - 1);
        if (channel.getChannel() == 10) {
            channel.setChannel(SongTrack.getDefaultPercusionChannel());
        }
        if ((instrument = channel.getInstrument()) == -1) {
            channel.setInstrument(0);
        }
        channel.setChannel(SongManager.getFreeChannel(tracks, instrument, channel.getChannel() == SongTrack.getDefaultPercusionChannel()));
        return channel;
    }

    private int readUnsignedByte() throws IOException {
        return this.read();
    }

    private void readChordType() throws IOException {
        this.readUnsignedByte();
    }

    private void readRoot() throws IOException {
        this.readByte();
    }

    private void readTonalityType(int numBytes) throws IOException {
        if (numBytes == 1) {
            int type = this.readUnsignedByte();
        } else if (numBytes == 4) {
            int n = this.readInt();
        }
    }

    private String readChordName() throws IOException {
        byte[] nameB = new byte[21];
        char[] nameC = new char[20];
        this.read(nameB, 0, 21);
        int max = 20;
        if (nameB[0] < max) {
            max = nameB[0];
        }
        int i = 1;
        while (i <= max) {
            nameC[i - 1] = (char)nameB[i];
            ++i;
        }
        return String.valueOf(nameC, 0, max);
    }

    private void readChordDiagram() throws IOException, GPFormatException {
        int n;
        int header = this.readUnsignedByte();
        if ((header & 1) == 0) {
            throw new GPFormatException("Cannot Read Chord Diagram");
        }
        boolean sharp = this.readBoolean();
        this.skip(3L);
        this.readRoot();
        this.readChordType();
        int nineElevenThirteen = this.readUnsignedByte();
        int bass = this.readInt();
        this.readTonalityType(4);
        int addedNote = this.readUnsignedByte();
        String name = this.readChordName();
        this.skip(2L);
        this.readTonalityType(1);
        this.readTonalityType(1);
        this.readTonalityType(1);
        int baseFret = this.readInt();
        int i = 1;
        while (i <= 7) {
            int n2 = this.readInt();
            ++i;
        }
        int numBarres = this.readUnsignedByte();
        i = 1;
        while (i <= 5) {
            n = this.readUnsignedByte();
            ++i;
        }
        i = 1;
        while (i <= 5) {
            n = this.readUnsignedByte();
            ++i;
        }
        i = 1;
        while (i <= 5) {
            n = this.readUnsignedByte();
            ++i;
        }
        long aux = this.skip(8L);
        i = 1;
        while (i <= 7) {
            n = this.readByte();
            ++i;
        }
        boolean chordFingeringDisplayed = this.readBoolean();
    }

    private void readGraceNote() throws IOException {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)this.readUnsignedByte();
            ++i;
        }
    }

    private void readBendPoint() throws IOException {
        int position = this.readInt();
        int value = this.readInt();
        byte vibrato = this.readByte();
    }

    private void readBend() throws IOException {
        byte type = this.readByte();
        int value = this.readInt();
        int numPoints = this.readInt();
        int i = 0;
        while (i < numPoints) {
            this.readBendPoint();
            ++i;
        }
    }

    private void readNoteEffects() throws IOException {
        int header1 = this.readUnsignedByte();
        int header2 = this.readUnsignedByte();
        if ((header1 & 1) != 0) {
            this.readBend();
        }
        if ((header1 & 0x10) != 0) {
            this.readGraceNote();
        }
        if ((header2 & 4) != 0) {
            this.readUnsignedByte();
        }
        if ((header2 & 8) != 0) {
            this.readByte();
        }
        if ((header2 & 0x10) != 0) {
            byte by = this.readByte();
        }
        if ((header2 & 0x20) != 0) {
            byte fret = this.readByte();
            byte by = this.readByte();
        }
    }

    private void readBeatEffects() throws IOException {
        int[] header = new int[]{this.readUnsignedByte(), this.readUnsignedByte()};
        if ((header[0] & 0x20) != 0) {
            int effect = this.readUnsignedByte();
            switch (effect) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        if ((header[1] & 4) != 0) {
            this.readBend();
        }
        if ((header[0] & 0x40) != 0) {
            byte durationValue = this.readByte();
            byte by = this.readByte();
        }
        int cfr_ignored_0 = header[1];
        if ((header[1] & 2) != 0) {
            this.readByte();
        }
    }

    private void readMixChange(Tempo tempo) throws IOException {
        int aux;
        int[] pos = new int[8];
        int n = 0;
        int i = 0;
        while (i < 7) {
            aux = this.readByte();
            if (i != 0 && aux != -1) {
                pos[n] = i;
                ++n;
            }
            ++i;
        }
        aux = this.readInt();
        if (aux != -1) {
            tempo.setValue(aux);
            pos[n] = i;
            ++n;
        }
        i = 0;
        while (i < n) {
            aux = this.readByte();
            ++i;
        }
        int applyToAllTracks = this.readUnsignedByte();
    }

    private class Channel {
        private int channel;
        private int instrument;
        private byte volume;
        private byte balance;
        private byte chorus;
        private byte reverb;
        private byte phaser;
        private byte tremolo;

        public Channel(int channel, int instrument, byte volume, byte balance, byte chorus, byte reverb, byte phaser, byte tremolo) {
            this.channel = channel;
            this.instrument = instrument;
            this.volume = volume;
            this.balance = balance;
            this.chorus = chorus;
            this.reverb = reverb;
            this.phaser = phaser;
            this.tremolo = tremolo;
        }

        public byte getBalance() {
            return this.balance;
        }

        public void setBalance(byte balance) {
            this.balance = balance;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int channel) {
            this.channel = channel;
        }

        public byte getChorus() {
            return this.chorus;
        }

        public void setChorus(byte chorus) {
            this.chorus = chorus;
        }

        public int getInstrument() {
            return this.instrument;
        }

        public void setInstrument(int instrument) {
            this.instrument = instrument;
        }

        public byte getPhaser() {
            return this.phaser;
        }

        public void setPhaser(byte phaser) {
            this.phaser = phaser;
        }

        public byte getReverb() {
            return this.reverb;
        }

        public void setReverb(byte reverb) {
            this.reverb = reverb;
        }

        public byte getTremolo() {
            return this.tremolo;
        }

        public void setTremolo(byte tremolo) {
            this.tremolo = tremolo;
        }

        public byte getVolume() {
            return this.volume;
        }

        public void setVolume(byte volume) {
            this.volume = volume;
        }
    }
}

