/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.widgets.DurationCoords;
import org.herac.tuxguitar.gui.tab.widgets.MeasureComponent;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.Tablature;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Silence;

public class SilenceCoords
implements MeasureComponent {
    private Tablature tablature;
    private MeasureCoords meassureCoords;
    private Silence silence;
    private Image image;
    private int posX;
    private int posY;
    private DurationCoords durationCoords;

    public SilenceCoords(Tablature tablature, MeasureCoords meassureCoords, Silence silence, int posX, int posY) {
        this.tablature = tablature;
        this.meassureCoords = meassureCoords;
        this.silence = silence;
        this.posX = posX;
        this.posY = posY;
    }

    public void update() {
        String fileName;
        String path;
        if (this.getDuration() != null && (path = TuxGuitar.getResourcePath(this, fileName = "silence" + this.getDuration().getValue() + ".gif")) != null) {
            this.image = new Image((Device)this.tablature.getDisplay(), path);
        }
    }

    public void paint(GC gc, int fromX, int fromY) {
        if (this.silence != null) {
            int center = this.meassureCoords.getHeight() / 2;
            int x = this.posX + fromX - 10;
            int y = fromY + (center - 10);
            gc.drawImage(this.image, x, y);
            if (this.silence.getDuration().isDotted()) {
                gc.drawOval(x + 23, y + 15, 1, 1);
            }
            if (!this.silence.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
                gc.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()), x + 15, y + 81);
            }
        } else {
            int x = this.posX + fromX + 3;
            int y = this.posY + fromY + 15;
            gc.drawString("S", x, y);
        }
    }

    public void setDuration(Duration duration) {
        this.silence.setDuration(duration);
    }

    public Duration getDuration() {
        return this.silence.getDuration();
    }

    public void setStart(long start) {
        this.silence.setStart(start);
    }

    public long getStart() {
        return this.silence.getStart();
    }

    public Silence getSilence() {
        return this.silence;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

