/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.tab.widgets.DurationCoords;
import org.herac.tuxguitar.gui.tab.widgets.MeasureComponent;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;

public class NoteCoords
implements MeasureComponent {
    private static final int JOINED_TYPE_NONE = 0;
    private static final int JOINED_TYPE_LEFT = 1;
    private static final int JOINED_TYPE_RIGHT = 2;
    private MeasureCoords meassureCoords;
    private Note note;
    private int posX;
    private int posY;
    private int lastFromX;
    private int lastFromY;
    private DurationCoords durationCoords;
    private int joinedType;
    private SongTrackCoords trackCoords;

    public NoteCoords(SongTrackCoords trackCoords, MeasureCoords meassureCoords, Note note, int posX, int posY) {
        this.trackCoords = trackCoords;
        this.meassureCoords = meassureCoords;
        this.note = note;
        this.posX = posX;
        this.posY = posY;
        this.durationCoords = new DurationCoords();
    }

    public void update() {
        this.joinedType = 0;
        this.durationCoords.setX1(this.getPosX());
        this.durationCoords.setX2(this.getPosX() + 6);
        this.durationCoords.setEighthY(this.meassureCoords.getHeight() + 25);
        this.durationCoords.setSixteenthY(this.meassureCoords.getHeight() + 20);
        this.durationCoords.setThirtySecondY(this.meassureCoords.getHeight() + 15);
        this.durationCoords.setSixtyFourthY(this.meassureCoords.getHeight() + 10);
        boolean noteJoined = false;
        boolean widthPrev = false;
        MeasureComponent prevComponent = this.meassureCoords.getPreviousComponent(this);
        MeasureComponent nextComponent = this.meassureCoords.getNextComponent(this);
        NoteCoords prevNote = null;
        NoteCoords nextNote = null;
        if (prevComponent instanceof NoteCoords && this.meassureCoords.areInSameBeat(this, prevNote = (NoteCoords)prevComponent)) {
            widthPrev = true;
            if (prevNote.getNote().getDuration().getValue() >= this.note.getDuration().getValue()) {
                this.durationCoords.setX1(prevNote.getPosX());
                if (nextNote == null || nextNote.getNote().getDuration().getValue() < this.note.getDuration().getValue()) {
                    this.durationCoords.setX2(this.getPosX());
                }
                noteJoined = true;
                this.joinedType = 1;
            }
        }
        if (nextComponent instanceof NoteCoords && this.meassureCoords.areInSameBeat(this, nextNote = (NoteCoords)nextComponent) && nextNote.getNote().getDuration().getValue() >= this.note.getDuration().getValue()) {
            this.durationCoords.setX2(nextNote.getPosX());
            if (prevNote == null || prevNote.getNote().getDuration().getValue() < this.note.getDuration().getValue()) {
                this.durationCoords.setX1(this.getPosX());
            }
            noteJoined = true;
            this.joinedType = 2;
        }
        if (!noteJoined && widthPrev) {
            this.durationCoords.setX1(this.getPosX() - 5);
            this.durationCoords.setX2(this.getPosX());
            this.joinedType = 1;
        }
        this.updateUsedStrings();
    }

    private void updateUsedStrings() {
        if (this.note.getDuration().getValue() >= 4) {
            boolean[] usedStrings = new boolean[this.trackCoords.getTrack().getStrings().size()];
            List notesAtBeat = this.meassureCoords.getComponents(this.getStart());
            Iterator it = notesAtBeat.iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent)it.next();
                if (!(component instanceof NoteCoords)) continue;
                NoteCoords currNote = (NoteCoords)component;
                usedStrings[currNote.getNote().getString() - 1] = true;
            }
            this.durationCoords.setUsedStrings(usedStrings);
        }
    }

    public void paint(GC gc, int fromX, int fromY) {
        int x = fromX + this.getPosX();
        int y = fromY + this.getPosY();
        if (this.getNote().isTiedNote()) {
            NoteCoords noteForTie = this.getNoteForTie();
            if (noteForTie != null) {
                int noteForTieFomrX = noteForTie.getLastFromX();
                int noteForTieFomrY = noteForTie.getLastFromY();
                int ligadureX = noteForTie.getPosX() + noteForTieFomrX;
                int ligadureY = noteForTie.getPosY() + noteForTieFomrY + 10;
                gc.drawArc(ligadureX, ligadureY, x - ligadureX, -30, 225, 90);
            }
        } else {
            x -= 2;
            if (this.getNote().getValue() > 9) {
                x -= 4;
            }
            gc.drawString(Integer.toString(this.getNote().getValue()), x, y - 7);
        }
        this.paintDuration(gc, fromX, fromY);
        this.lastFromX = fromX;
        this.lastFromY = fromY;
    }

    private NoteCoords getNoteForTie() {
        List currComponents = this.meassureCoords.getComponentsBeforeEnd(this.meassureCoords.getMeasure().getStart());
        int cIdx = currComponents.size() - 1;
        while (cIdx >= 0) {
            NoteCoords noteCoords;
            MeasureComponent component = (MeasureComponent)currComponents.get(cIdx);
            if (component.getStart() < this.getNote().getStart() && component instanceof NoteCoords && (noteCoords = (NoteCoords)component).getNote().getString() == this.getNote().getString()) {
                return noteCoords;
            }
            --cIdx;
        }
        int mIdx = this.meassureCoords.getMeasureId();
        while (mIdx >= 0) {
            MeasureCoords measureCoords = (MeasureCoords)this.trackCoords.getMeasuresCoords().get(mIdx);
            List components = measureCoords.getComponentsBeforeEnd(measureCoords.getMeasure().getStart());
            int cIdx2 = components.size() - 1;
            while (cIdx2 >= 0) {
                NoteCoords noteCoords;
                MeasureComponent component = (MeasureComponent)components.get(cIdx2);
                if (component.getStart() < this.getNote().getStart() && component instanceof NoteCoords && (noteCoords = (NoteCoords)component).getNote().getString() == this.getNote().getString()) {
                    return noteCoords;
                }
                --cIdx2;
            }
            --mIdx;
        }
        return null;
    }

    private void paintDuration(GC gc, int fromX, int fromY) {
        int x = fromX + this.getPosX();
        int y1 = fromY + this.getPosY();
        int y2 = fromY + this.meassureCoords.getHeight() + 25;
        this.paintVerticalLine(gc, fromX, fromY);
        if (this.note.getDuration().getValue() >= 8) {
            this.paintJoindeds(gc, fromX, fromY);
        }
        if (this.note.getDuration().isDotted()) {
            this.paintDotted(gc, fromX, fromY);
        }
        if (!this.note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
            gc.drawString(Integer.toString(this.note.getDuration().getTupleto().getEnters()), x, y2 + 10);
        }
    }

    private void paintVerticalLine(GC gc, int fromX, int fromY) {
        int x = fromX + this.getPosX();
        if (this.note.getDuration().getValue() >= 4) {
            boolean[] usedStrings = this.durationCoords.getUsedStrings();
            int i = this.getNote().getString() - 1;
            while (i < usedStrings.length) {
                if (!usedStrings[i]) {
                    int stringPosition = fromY + 12 * (i + 1);
                    int y1 = stringPosition - 6;
                    int y2 = stringPosition + 6;
                    gc.drawLine(x, y1, x, y2);
                }
                ++i;
            }
            int y = fromY + this.meassureCoords.getHeight() + 6;
            gc.drawLine(x, y, x, y + 19);
        } else if (this.note.getDuration().getValue() == 2) {
            int y = fromY + this.meassureCoords.getHeight() + 6 + 9;
            gc.drawLine(x, y, x, y + 10);
        }
    }

    public void paintJoindeds(GC gc, int fromX, int fromY) {
        gc.setLineWidth(2);
        int x1 = this.durationCoords.getX1();
        int x2 = this.durationCoords.getX2();
        int eighthY = this.durationCoords.getEighthY();
        int sixteenthY = this.durationCoords.getSixteenthY();
        int thirtySecondY = this.durationCoords.getThirtySecondY();
        int sixtyFourthY = this.durationCoords.getSixtyFourthY();
        switch (this.note.getDuration().getValue()) {
            case 8: {
                gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
                break;
            }
            case 16: {
                gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
                gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
                break;
            }
            case 32: {
                gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
                gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
                gc.drawLine(fromX + x1, fromY + thirtySecondY, fromX + x2, fromY + thirtySecondY);
                break;
            }
            case 64: {
                gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
                gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
                gc.drawLine(fromX + x1, fromY + thirtySecondY, fromX + x2, fromY + thirtySecondY);
                gc.drawLine(fromX + x1, fromY + sixtyFourthY, fromX + x2, fromY + sixtyFourthY);
            }
        }
        gc.setLineWidth(1);
    }

    private void paintDotted(GC gc, int fromX, int fromY) {
        int x = fromX + this.getPosX();
        int y = fromY;
        switch (this.joinedType) {
            case 0: {
                x += 4;
                break;
            }
            case 1: {
                x -= 5;
                break;
            }
            case 2: {
                x += 4;
            }
        }
        switch (this.note.getDuration().getValue()) {
            case 8: {
                y += this.durationCoords.getEighthY() - 5;
                break;
            }
            case 16: {
                y += this.durationCoords.getSixteenthY() - 5;
                break;
            }
            case 32: {
                y += this.durationCoords.getThirtySecondY() - 5;
                break;
            }
            case 64: {
                y += this.durationCoords.getSixtyFourthY() - 5;
                break;
            }
            default: {
                y += this.meassureCoords.getHeight() + 22;
                x = fromX + this.getPosX() + 4;
            }
        }
        gc.drawOval(x, y, 1, 1);
    }

    public void setStart(long start) {
        this.note.setStart(start);
    }

    public long getStart() {
        return this.note.getStart();
    }

    public void setDuration(Duration duration) {
        this.note.setDuration(duration);
    }

    public Duration getDuration() {
        return this.note.getDuration();
    }

    public Note getNote() {
        return this.note;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getLastFromX() {
        return this.lastFromX;
    }

    public int getLastFromY() {
        return this.lastFromY;
    }
}

