/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;

public class UndoableToolItems
implements ItemContainer {
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;

    public UndoableToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }

    public void showItems() {
        ToolItem undo = new ToolItem(this.toolBar, 8);
        undo.setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "undo.png")));
        undo.setToolTipText("Undo");
        undo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    UndoableToolItems.this.tablatureEditor.getUndoManager().undo();
                }
                catch (CannotUndoException e) {
                    e.printStackTrace();
                }
            }
        });
        ToolItem redo = new ToolItem(this.toolBar, 8);
        redo.setImage(new Image((Device)this.toolBar.getDisplay(), TuxGuitar.getResourcePath(this, "redo.png")));
        redo.setToolTipText("Redo");
        redo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    UndoableToolItems.this.tablatureEditor.getUndoManager().redo();
                }
                catch (CannotRedoException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void update() {
    }
}

