/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongTrackCoords;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class MeasureTransferable
implements Transferable {
    private TablatureEditor tablatureEditor;
    private List measures;

    public MeasureTransferable(TablatureEditor tablatureEditor, long p1, long p2) {
        this.tablatureEditor = tablatureEditor;
        this.measures = new ArrayList();
        this.getTransfer(p1, p2);
    }

    private void getTransfer(long p1, long p2) {
        SongTrackCoords trackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        this.measures = trackCoords.copyMeasures(p1, p2);
    }

    public void insertTransfer() throws CannotInsertTransferException {
        List measures = null;
        MeasureCoords measure = this.tablatureEditor.getTablature().getCaret().getMeasureCoords();
        SongCoords songCoords = this.tablatureEditor.getTablature().getCaret().getSongCoords();
        SongTrackCoords trackCoords = this.tablatureEditor.getTablature().getCaret().getSongTrackCoords();
        if (measure == null || songCoords == null || trackCoords == null || this.measures.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        int fromIndex = measure.getMeasureId();
        long nextStart = measure.getMeasure().getStart();
        Iterator it = this.tablatureEditor.getTablature().getSongCoords().getTrackCoords().iterator();
        while (it.hasNext()) {
            SongTrackCoords currTrackCoords = (SongTrackCoords)it.next();
            measures = currTrackCoords.equals(trackCoords) ? this.getCloneMeasures(this.measures) : this.getEmptyMeasures(this.measures);
            this.moveStart(measures, nextStart);
            currTrackCoords.insertMeasures(measures, fromIndex);
        }
    }

    private void moveStart(List measures, long nextStart) {
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure)it.next();
            long theMove = nextStart - measure.getStart();
            Iterator notes = measure.getNotes().iterator();
            while (notes.hasNext()) {
                Note note = (Note)notes.next();
                note.setStart(note.getStart() + theMove);
            }
            Iterator silences = measure.getSilences().iterator();
            while (silences.hasNext()) {
                Silence silence = (Silence)silences.next();
                silence.setStart(silence.getStart() + theMove);
            }
            measure.setStart(measure.getStart() + theMove);
            nextStart = measure.getStart() + measure.getLength();
        }
    }

    private List getCloneMeasures(List measures) {
        ArrayList<Object> cloneMeasures = new ArrayList<Object>();
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure)it.next();
            cloneMeasures.add(measure.clone());
        }
        return cloneMeasures;
    }

    private List getEmptyMeasures(List measures) {
        ArrayList<Measure> emptyMeasures = new ArrayList<Measure>();
        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure)it.next();
            long start = measure.getStart();
            ArrayList notes = new ArrayList();
            ArrayList silences = new ArrayList();
            TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            boolean repeatStart = measure.isRepeatStart();
            int nombreOfRepetitions = measure.getNumberOfRepetitions();
            emptyMeasures.add(new Measure(start, notes, silences, timeSignature, tempo, repeatStart, nombreOfRepetitions));
        }
        return emptyMeasures;
    }
}

