/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.FileChooser;

public class SaveFileAction
extends Action {
    public static final String NAME = "SAVE_FILE";

    public SaveFileAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        String defaultChooserPath = this.getEditor().getMemoryHelper().getLastChooserPath();
        String defaultFileName = this.getDefaultFileName(this.getEditor().getMemoryHelper().getFileName());
        String[] filterNames = new String[]{"Tux Guitar Files"};
        String[] filterExtensions = new String[]{"*.tg"};
        FileChooser chooser = new FileChooser(this.getEditor(), filterNames, filterExtensions, defaultChooserPath, defaultFileName);
        String selectedName = chooser.show(8192);
        if (selectedName != null) {
            this.getEditor().getTablature().changeCursor(1);
            if (!this.isSuportedFormat(selectedName)) {
                selectedName = String.valueOf(selectedName) + this.getDefaultExtension();
            }
            final String fileName = selectedName;
            new Thread(new Runnable(){

                public void run() {
                    SaveFileAction.this.getEditor().getSongManager().save(fileName);
                    SaveFileAction.this.getEditor().notifyMemoryHelper(fileName);
                    new SyncThread(SaveFileAction.this.getEditor(), new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            SaveFileAction.access$0(1.access$0(this.this$1)).getTablature().changeCursor(0);
                        }
                    }).start();
                }

                static /* synthetic */ SaveFileAction access$0(1 var0) {
                    return var0.SaveFileAction.this;
                }
            }).start();
        }
        return true;
    }

    private String getDefaultFileName(String fileName) {
        String defaultFileName = "untitled";
        String defaultExtencion = this.getDefaultExtension();
        if (fileName == null) {
            fileName = String.valueOf(defaultFileName) + defaultExtencion;
        } else if (!this.isSuportedFormat(fileName)) {
            fileName = this.chengeFormat(fileName, defaultExtencion);
        }
        return fileName;
    }

    private boolean isSuportedFormat(String fileName) {
        return fileName.endsWith(".tg");
    }

    private String chengeFormat(String fileName, String format) {
        return String.valueOf(this.removeExtension(fileName)) + format;
    }

    private String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return fileName.substring(0, index);
    }

    private String getDefaultExtension() {
        return ".tg";
    }
}

