/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.MeasureCoords;
import org.herac.tuxguitar.gui.tab.widgets.SongCoords;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.TimeSignature;

public class ChangeTimeSignatureAction
extends Action {
    public static final String NAME = "CHANGE_TIME_SIGNATURE";

    public ChangeTimeSignatureAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        MeasureCoords measure = this.getEditor().getTablature().getCaret().getMeasureCoords();
        if (measure != null) {
            final Shell dialog = new Shell(shell, 67680);
            GridLayout layout = new GridLayout(2, true);
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            dialog.setLayout((Layout)layout);
            TimeSignature currentTimeSignature = measure.getMeasure().getTimeSignature();
            Label numeratorLabel = new Label((Composite)dialog, 0);
            numeratorLabel.setText("Numerator:");
            final Combo numerator = new Combo((Composite)dialog, 0);
            int i = 1;
            while (i <= 32) {
                numerator.add(Integer.toString(i));
                ++i;
            }
            numerator.setText(Integer.toString(currentTimeSignature.getNumerator()));
            Label denominatorLabel = new Label((Composite)dialog, 0);
            denominatorLabel.setText("Denominator:");
            final Combo denominator = new Combo((Composite)dialog, 0);
            int i2 = 1;
            while (i2 <= 32) {
                denominator.add(Integer.toString(i2));
                i2 *= 2;
            }
            denominator.setText(Integer.toString(currentTimeSignature.getDenominator().getValue()));
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            final Button toEnd = new Button((Composite)dialog, 32);
            toEnd.setText("To the end");
            toEnd.setLayoutData((Object)gridData);
            Button buttonOK = new Button((Composite)dialog, 8);
            buttonOK.setText("Ok");
            buttonOK.setLayoutData((Object)new GridData(128));
            buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    boolean toEndValue = toEnd.getSelection();
                    int numeratorValue = Integer.parseInt(numerator.getText());
                    int denominatorValue = Integer.parseInt(denominator.getText());
                    TimeSignature timeSignature = new TimeSignature(numeratorValue, new Duration(denominatorValue));
                    ChangeTimeSignatureAction.this.setTimeSignature(timeSignature, toEndValue);
                    dialog.dispose();
                }
            });
            Button buttonCancel = new Button((Composite)dialog, 8);
            buttonCancel.setText("Cancel");
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });
            dialog.pack();
            dialog.open();
            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }

    private void setTimeSignature(TimeSignature timeSignature, boolean toEnd) {
        Caret caret = this.getEditor().getTablature().getCaret();
        SongCoords songCoords = caret.getSongCoords();
        MeasureCoords measure = caret.getMeasureCoords();
        songCoords.changeTimeSignature(measure.getMeasure().getStart(), timeSignature, toEnd);
        this.updateTablature();
        caret.update(caret.getMeasureCoords().getMeasure());
        this.redraw();
    }
}

