/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.sql.Timestamp;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import util.TimeUtil;

public class TimeTextField
extends JFormattedTextField {
    public TimeTextField() {
        this.setFormat();
        this.setValue("--:--");
        this.setSize(45, (int)this.getPreferredSize().getHeight());
    }

    public TimeTextField(Timestamp t) {
        this();
        String value = TimeUtil.getStringByTime(t);
        if (!value.equals("")) {
            this.setValue(value);
        }
    }

    private void setFormat() {
        MaskFormatter fmt = null;
        try {
            fmt = new MaskFormatter("**:**");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        DefaultFormatterFactory fmtFactory = new DefaultFormatterFactory(fmt);
        this.setFormatterFactory(fmtFactory);
    }

    public String getInput() {
        if (this.getValue().equals("--:--")) {
            return "";
        }
        if (this.getValue().equals("  :  ")) {
            return "";
        }
        return (String)this.getValue();
    }

    public Timestamp getTime(String date) {
        if (this.getValue() == null) {
            return null;
        }
        return TimeUtil.getDateByString(date, (String)this.getValue());
    }
}

