/*
 * Decompiled with CFR 0.152.
 */
package system;

import database.DBConn;
import database.DBUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import system.Config;
import system.Constants;
import ui.DataDialog;
import ui.TableLayout;
import util.Tools;
import util.WinUtil;

public class SystemUpdate {
    private String gDbVersion = Config.getS(Config.dbVersion);

    public SystemUpdate() {
        String message;
        if (this.gDbVersion.equals("")) {
            this.gDbVersion = "1.0.0";
        }
        if (Constants.VERSION.equals(this.gDbVersion)) {
            return;
        }
        if (SystemUpdate.isUpdate(this.gDbVersion, Constants.VERSION)) {
            JOptionPane.showMessageDialog(null, "\u7cfb\u7d71\u6240\u9700\u7528\u8cc7\u6599\u5eab\u7248\u672c:" + Constants.VERSION + " \u8207\u73fe\u5b58\u8cc7\u6599\u5eab\u7248\u672c:" + this.gDbVersion + " \u4e0d\u7b26\u5408,\u7a0b\u5f0f\u7d42\u6b62.");
            System.exit(0);
        }
        if (!WinUtil.getConfirm(null, "\u7cfb\u7d71\u7684\u7248\u672c:" + Constants.VERSION + " \u6bd4\u73fe\u5b58\u8cc7\u6599\u5eab\u7248\u672c:" + this.gDbVersion + " \u70ba\u65b0,\u662f\u5426\u73fe\u5728\u9032\u884c\u8cc7\u6599\u5eab\u66f4\u65b0?")) {
            JOptionPane.showMessageDialog(null, "\u8cc7\u6599\u5eab\u5fc5\u9808\u66f4\u65b0\u624d\u80fd\u4f7f\u7528\u7cfb\u7d71,\u7a0b\u5f0f\u7d42\u6b62.");
            System.exit(0);
        }
        if (!WinUtil.getConfirm(null, message = "\u8acb\u5148\u78ba\u5b9a\u4ee5\u4e0b\u624b\u52d5\u6b65\u9a5f\u5df2\u7d93\u5b8c\u6210:\n(\u82e5\u914d\u5408\u4f7f\u7528Webtool,\u8acb\u5148\u505c\u6b62\u8cc7\u6599\u5eab,\u5b8c\u6210\u9019\u756b\u9762\u7684\u6b65\u9a5f\u5f8c\u5728\u65b0\u7cfb\u7d71\u4e0b\u555f\u52d5\u8cc7\u6599\u5eab)\n1.\u5099\u4efd\u6574\u500b\u7cfb\u7d71(\u8907\u88fd\u6574\u500bacts\u8cc7\u6599\u593e\u5373\u53ef)\n2.\u5c07\u539f\u4f86acts\\config , acts\\db\u53caacts\\image\u8cc7\u6599\u593e\u53d6\u4ee3\u5230\u65b0\u7684acts\u7684\u76f8\u540c\u8def\u5f91\u4e0b")) {
            JOptionPane.showMessageDialog(null, "\u8acb\u7a0d\u5f8c\u518d\u9032\u884c\u66f4\u65b0,\u7a0b\u5f0f\u7d42\u6b62.");
            System.exit(0);
        }
        AdminPasswordDialog apd = new AdminPasswordDialog(null);
        this.processUpdate();
    }

    public void processUpdate() {
        boolean success = false;
        DBConn conn = new DBConn(false);
        if (this.gDbVersion.equals("1.0.0")) {
            success = this.update100to110(conn);
        }
        conn.commit();
        if (success) {
            JOptionPane.showMessageDialog(null, "\u66f4\u65b0\u7cfb\u7d71\u5b8c\u6210");
        } else {
            JOptionPane.showMessageDialog(null, "\u66f4\u65b0\u7cfb\u7d71\u5931\u6557,\u8a73\u60c5\u8acb\u770berror.txt");
            System.exit(0);
        }
    }

    private boolean update100to110(DBConn conn) {
        String sql = "";
        boolean success = false;
        sql = "alter table member add column receipt_type varchar(6);";
        DBUtil.run(sql, conn);
        sql = "update member set receipt_type='P';";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column require_receipt varchar(1);";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column email_status varchar(6);";
        DBUtil.run(sql, conn);
        sql = "alter table receipt add column email_time timestamp(6);";
        DBUtil.run(sql, conn);
        sql = "update receipt set require_receipt='Y',email_status='NA';";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('receiptApprove','\u6536\u64da\u6279\u6838','N',1850);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege(user_privilege_seq,user_seq,member_group_seq,privilege) select next value for user_privilege_seq,user_seq,1,'receiptApprove' from user_privilege where privilege='receiptModify';";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('lang','TC');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('emailHost','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,i) values ('emailPort',25);";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('emailUser','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('emailPwd','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('adminEmail','');";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request drop column approve_user_seq;";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request drop column approve_date;";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request add column member_group_seq int;";
        DBUtil.run(sql, conn);
        sql = "update venue_request set member_group_seq=1;";
        DBUtil.run(sql, conn);
        sql = "alter table venue_request add column email_status varchar(6);";
        DBUtil.run(sql, conn);
        sql = "update venue_request set email_status='NA';";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('venueRequestApprove','\u5834\u5730\u7533\u8acb\u6279\u6838','N',1350);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege(user_privilege_seq,user_seq,member_group_seq,privilege) select next value for user_privilege_seq,user_seq,1,'venueRequestApprove' from user_privilege where privilege='venueRequestModify';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set name='\u6703\u773e\u7fa4\u7d44\u6aa2\u8996' where privilege='memberGroupRead';";
        DBUtil.run(sql, conn);
        sql = "update user_privilege_base set name='\u6703\u773e\u7fa4\u7d44\u4fee\u6539' where privilege='memberGroupModify';";
        DBUtil.run(sql, conn);
        sql = "delete from config where name='venueRequestApproval';";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,t) values ('venueRequestMaxDate','2099-01-01 21:00:00');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('venueRequestEmail','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('receiptEmail','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('enableEmail','N');";
        DBUtil.run(sql, conn);
        sql = "update activity set remark=coalesce(remark,'')||'(\u5834\u5730: '||coalesce(venue,'N/A')||')';";
        DBUtil.run(sql, conn);
        sql = "alter table activity drop column venue;";
        DBUtil.run(sql, conn);
        sql = "alter table activity add column venue_seq int;";
        DBUtil.run(sql, conn);
        sql = "insert into venue(venue_seq,name,status,user_capacity,request_before,has_floor_plan) values (next value for venue_seq,'\u5176\u4ed6','A','10000','0','N');";
        DBUtil.run(sql, conn);
        sql = "update activity set venue_seq=(select max(venue_seq) from venue);";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('uid','');";
        DBUtil.run(sql, conn);
        sql = "insert into config(name,s) values ('autoCheckUpdate','N');";
        DBUtil.run(sql, conn);
        sql = "alter table user add column known_version varchar(32);";
        DBUtil.run(sql, conn);
        sql = "update user set known_version='1.1.0';";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('memberReport','\u6703\u773e\u8cc7\u6599\u5831\u8868','N',950);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('venueRequestReport','\u5834\u5730\u7533\u8acb\u5831\u8868','N',1375);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('importData','\u532f\u5165\u8cc7\u6599','N',575);";
        DBUtil.run(sql, conn);
        sql = "insert into user_privilege_base(privilege,name,has_member_group,display_seq) values ('runSQL','\u57f7\u884cSQL','N',585);";
        DBUtil.run(sql, conn);
        sql = "alter table master_code alter column name varchar(128);";
        DBUtil.run(sql, conn);
        sql = "alter table master_code alter column code_group varchar(50);";
        DBUtil.run(sql, conn);
        sql = "alter table master_code alter column sub_code varchar(50);";
        DBUtil.run(sql, conn);
        sql = "update config set s='1.1.0',i=null where name='dbVersion';";
        DBUtil.run(sql, conn);
        sql = "update config set t=now() where name='dbUpdateDate';";
        DBUtil.run(sql, conn);
        return conn.isRunnable();
    }

    public static boolean isUpdate(String ver1, String ver2) {
        int fix2;
        int fix1;
        block5: {
            int min2;
            int min1;
            block4: {
                try {
                    StringTokenizer v1 = new StringTokenizer(ver1, ".");
                    StringTokenizer v2 = new StringTokenizer(ver2, ".");
                    int maj1 = Integer.parseInt(v1.nextToken());
                    min1 = Integer.parseInt(v1.nextToken());
                    fix1 = Integer.parseInt(v1.nextToken());
                    int maj2 = Integer.parseInt(v2.nextToken());
                    min2 = Integer.parseInt(v2.nextToken());
                    fix2 = Integer.parseInt(v2.nextToken());
                    if (maj1 >= maj2) break block4;
                    return false;
                }
                catch (Exception e) {
                    Tools.writeError(e.toString());
                    return true;
                }
            }
            if (min1 >= min2) break block5;
            return false;
        }
        return fix1 >= fix2;
    }

    private class AdminPasswordDialog
    extends DataDialog {
        private JPasswordField passwordTF;
        private JButton saveB;
        private JButton cancelB;

        public AdminPasswordDialog(JFrame frame) {
            super(frame, "\u5bc6\u78bc", true);
            this.setDefaultCloseOperation(0);
            this.setLayout();
            this.setEventHandler();
            this.setVisible(true);
            this.setModal(true);
        }

        public void setLayout() {
            TableLayout t = new TableLayout(this, 250, 170, 20, 20);
            int[] nArray = new int[2];
            nArray[0] = 60;
            t.addTable(nArray, new int[]{30, 30});
            this.passwordTF = new JPasswordField();
            JLabel jLabel = new JLabel("\u8acb\u8f38\u5165\u7cfb\u7d71\u7ba1\u7406\u54e1\u5bc6\u78bc\u4f86\u555f\u52d5\u66f4\u65b0\u7a0b\u5e8f");
            t.getClass();
            t.getClass();
            t.addCell(jLabel, 0, 0, -1, 0);
            JLabel jLabel2 = new JLabel("\u5bc6\u78bc");
            t.getClass();
            t.getClass();
            t.addCell(jLabel2, 0, 1, 1, 0);
            t.getClass();
            t.getClass();
            t.addCell(this.passwordTF, 1, 1, 20, 0, 120, -1);
            t.addYSpace(10);
            t.addTable(new int[]{100, 20, 80}, new int[]{20});
            this.saveB = new JButton("\u78ba\u5b9a");
            this.cancelB = new JButton("\u53d6\u6d88");
            t.addCell(this.saveB, 0, 0, 1, 10);
            t.addCell(this.cancelB, 2, 0, -1, 10);
        }

        public void setEventHandler() {
            this.saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AdminPasswordDialog.this.onSave(evt);
                }
            });
            this.cancelB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AdminPasswordDialog.this.onCancel(evt);
                }
            });
        }

        public void onSave(ActionEvent evt) {
            String password = new String(this.passwordTF.getPassword());
            if (!Tools.md5(password).equals(Config.getS(Config.adminPwd))) {
                JOptionPane.showMessageDialog(null, "\u5bc6\u78bc\u4e0d\u6b63\u78ba.");
                return;
            }
            this.dispose();
        }

        public void onCancel(ActionEvent evt) {
            JOptionPane.showMessageDialog(null, "\u8cc7\u6599\u5eab\u5fc5\u9808\u66f4\u65b0\u624d\u80fd\u4f7f\u7528\u7cfb\u7d71,\u7a0b\u5f0f\u7d42\u6b62.");
            System.exit(0);
        }
    }
}

