/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountBalance;
import account.AccountMonth;
import java.math.BigDecimal;
import java.util.ArrayList;
import printout.xls.ExcelFormat;
import printout.xls.ExcelPrintout;
import system.Config;
import system.Lang;
import util.Arith;
import util.ArrayListCreator;
import util.ArrayUtil;
import util.TimeUtil;

public class TrialBalance {
    private ArrayList g_Accounts = null;
    private ExcelPrintout g_Printout = null;
    private ArrayList g_Bf_balances = null;
    private ArrayList g_Period_balances = null;
    private int g_Row = 0;
    private boolean g_Show_group_total = false;
    private boolean g_Show_zero_ac = false;
    private double g_Ttl_bf_debit = 0.0;
    private double g_Ttl_bf_credit = 0.0;
    private double g_Ttl_month_debit = 0.0;
    private double g_Ttl_month_credit = 0.0;
    private static final String INDENT = "  ";

    public TrialBalance(int start_acm_seq, int end_acm_seq, boolean show_group_total, boolean show_zero_ac) {
        this.g_Show_group_total = show_group_total;
        this.g_Show_zero_ac = show_zero_ac;
        AccountMonth start_month = new AccountMonth(start_acm_seq);
        AccountMonth end_month = new AccountMonth(end_acm_seq);
        this.g_Accounts = Account.getAllAccounts();
        ArrayList ac_seqs = ArrayUtil.getCol(this.g_Accounts, "AC_SEQ");
        this.g_Bf_balances = AccountBalance.getBfBalances(TimeUtil.adjustDate(start_month.getStart_date(), -1), ac_seqs);
        this.g_Period_balances = AccountBalance.getPeriodBalances(start_month.getEnd_date(), end_month.getEnd_date(), ac_seqs);
        this.g_Printout = new ExcelPrintout(ExcelFormat.PA4, new int[]{42, 24, 24, 22, 22, 24, 24});
        this.g_Printout.addHeader(Config.getS(Config.companyName), Lang.set("\u8a66\u7b97\u8868"), new String[]{String.valueOf(Lang.set("\u6642\u671f: ")) + TimeUtil.getStringByDate(start_month.getStart_date()) + " - " + TimeUtil.getStringByDate(end_month.getEnd_date()), String.valueOf(Lang.set("\u5e33\u6236\u7e3d\u6578: ")) + this.g_Period_balances.size()});
        this.g_Row = this.g_Printout.getRowNumAfterHeader();
        this.g_Printout.addCell(0, this.g_Row, Lang.set("\u5e33\u6236"), this.g_Printout.TL);
        this.g_Printout.addCell(1, this.g_Row, String.valueOf(Lang.set("\u627f\u4e0a\u501f\u65b9(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(2, this.g_Row, String.valueOf(Lang.set("\u627f\u4e0a\u8cb8\u65b9(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(3, this.g_Row, String.valueOf(Lang.set("\u672c\u671f\u501f\u65b9(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(4, this.g_Row, String.valueOf(Lang.set("\u672c\u671f\u8cb8\u65b9(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(5, this.g_Row, String.valueOf(Lang.set("\u7d2f\u7a4d\u501f\u65b9(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.g_Printout.addCell(6, this.g_Row, String.valueOf(Lang.set("\u7d2f\u7a4d\u8cb8\u65b9(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.TR);
        this.printTypeAccounts(this.g_Accounts);
        double ttl_all_debit = Arith.add(this.g_Ttl_bf_debit, this.g_Ttl_month_debit);
        double ttl_all_credit = Arith.add(this.g_Ttl_bf_credit, this.g_Ttl_month_credit);
        ++this.g_Row;
        this.g_Printout.addCell(0, this.g_Row, String.valueOf(Lang.set("\u7e3d\u984d(")) + Config.getS(Config.currencyCode) + ")", this.g_Printout.AR);
        this.g_Printout.addCell(1, this.g_Row, this.g_Ttl_bf_debit, this.g_Printout.BTBD);
        this.g_Printout.addCell(2, this.g_Row, this.g_Ttl_bf_credit, this.g_Printout.BTBD);
        this.g_Printout.addCell(3, this.g_Row, this.g_Ttl_month_debit, this.g_Printout.BTBD);
        this.g_Printout.addCell(4, this.g_Row, this.g_Ttl_month_credit, this.g_Printout.BTBD);
        this.g_Printout.addCell(5, this.g_Row, ttl_all_debit, this.g_Printout.BTBD);
        this.g_Printout.addCell(6, this.g_Row, ttl_all_credit, this.g_Printout.BTBD);
        this.g_Printout.genPrintout();
    }

    private void printTypeAccounts(ArrayList type_acs) {
        ArrayList first_level_acs = ArrayUtil.getGroupItems(type_acs, "PARENT_AC_SEQ", new Integer(-1));
        ++this.g_Row;
        ArrayList self_totals = this.getNewEmptyTotals();
        this.printGroupAccounts(0, first_level_acs, self_totals);
    }

    private void printGroupAccounts(int level, ArrayList group_acs, ArrayList parent_totals) {
        int i = 0;
        while (i < group_acs.size()) {
            int ac_seq = ArrayUtil.getInt("AC_SEQ", i, group_acs);
            String is_parent = ArrayUtil.getString("IS_PARENT", i, group_acs);
            String id = ArrayUtil.getString("ID", i, group_acs);
            String name = ArrayUtil.getString("NAME", i, group_acs);
            String id_name = String.valueOf(this.getIndent(level)) + id + " " + name;
            boolean is_debit = this.isDebit(ArrayUtil.getString("TYPE", i, group_acs));
            int row = ++this.g_Row;
            double bf_bal = 0.0;
            double month_bal = 0.0;
            double all_bal = 0.0;
            if (is_parent.equals("N")) {
                int k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), this.g_Bf_balances);
                bf_bal = k != -1 ? ArrayUtil.getDouble("BALANCE", k, this.g_Bf_balances) : 0.0;
                k = ArrayUtil.indexOf("AC_SEQ", new Integer(ac_seq), this.g_Period_balances);
                month_bal = k != -1 ? ArrayUtil.getDouble("BALANCE", k, this.g_Period_balances) : 0.0;
                all_bal = Arith.add(bf_bal, month_bal);
                if (is_debit) {
                    this.g_Ttl_bf_debit = Arith.add(this.g_Ttl_bf_debit, bf_bal);
                    this.g_Ttl_month_debit = Arith.add(this.g_Ttl_month_debit, month_bal);
                } else {
                    this.g_Ttl_bf_credit = Arith.sub(this.g_Ttl_bf_credit, bf_bal);
                    this.g_Ttl_month_credit = Arith.sub(this.g_Ttl_month_credit, month_bal);
                }
            } else {
                ArrayList next_level_acs = ArrayUtil.getGroupItems(this.g_Accounts, "PARENT_AC_SEQ", new Integer(ac_seq));
                ArrayList self_totals = this.getNewEmptyTotals();
                this.printGroupAccounts(level + 1, next_level_acs, self_totals);
                bf_bal = ArrayUtil.getDouble("BF_BAL", 0, self_totals);
                month_bal = ArrayUtil.getDouble("MONTH_BAL", 0, self_totals);
                all_bal = Arith.add(bf_bal, month_bal);
            }
            if (bf_bal == 0.0 && month_bal == 0.0 && !this.g_Show_zero_ac) {
                --this.g_Row;
            } else {
                this.g_Printout.addCell(0, row, id_name);
                if (is_parent.equals("N") || this.g_Show_group_total) {
                    if (is_debit && bf_bal != 0.0) {
                        this.g_Printout.addCell(1, row, bf_bal);
                    }
                    if (!is_debit && bf_bal != 0.0) {
                        this.g_Printout.addCell(2, row, Arith.mul(-1.0, bf_bal));
                    }
                    if (is_debit && month_bal != 0.0) {
                        this.g_Printout.addCell(3, row, month_bal);
                    }
                    if (!is_debit && month_bal != 0.0) {
                        this.g_Printout.addCell(4, row, Arith.mul(-1.0, month_bal));
                    }
                    if (is_debit && all_bal != 0.0) {
                        this.g_Printout.addCell(5, row, all_bal);
                    }
                    if (!is_debit && all_bal != 0.0) {
                        this.g_Printout.addCell(6, row, Arith.mul(-1.0, all_bal));
                    }
                }
                ArrayUtil.addDouble("BF_BAL", bf_bal, 0, parent_totals);
                ArrayUtil.addDouble("MONTH_BAL", month_bal, 0, parent_totals);
            }
            ++i;
        }
    }

    private ArrayList getNewEmptyTotals() {
        ArrayListCreator creator = new ArrayListCreator(new String[]{"bf_bal", "month_bal"});
        creator.add(new Object[]{new BigDecimal(0), new BigDecimal(0)});
        return creator.getArrayList();
    }

    private boolean isDebit(String type) {
        return type.equals("A") || type.equals("E");
    }

    private String getIndent(int level) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < level) {
            b.append(INDENT);
            ++i;
        }
        return b.toString();
    }
}

