/*******************************************************************************
 * booter/real_mode/main.s
 *                                                                   2012/10/06
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
.intel_syntax noprefix
.code16

.global start
.extern enable_a20
.extern main

.section .text
/*
 * Booterのエントリ
 */
start:
	/* ビデオモード変更 */
	mov		ax, 0x0003
	int		0x10
	
	/* A20ライン有効化 */
	call enable_a20
	cmp		ax, 0
	je		start_1		/* 成功 */
	call	stop		/* 停止 */
	
start_1:
	/* GDT設定 */
	lgdt	[gdtrp]
	
	/* 割込み無効化 */
	mov		al, 0xFF		/* PICの設定値 */
	out		0xA1, al		/* PIC2の割込み設定 */
	nop
	out		0x21, al		/* PIC1の割込み設定 */
	cli						/* CPUの割込み設定 */
	
	/* 保護モードに設定 */
	mov		eax, cr0
	or		eax, 0x00000001
	mov		cr0, eax		/* 保護モード設定 */
	jmp		start_2			/* パイプラインリセット */
start_2:
	/* セグメント初期化 */
	mov		ax, 2 * 8
	mov		ds, ax
	mov		es, ax
	mov		fs, ax
	mov		gs, ax
	mov		ss, ax
	
	/* 保護モード処理部へ */
	jmp 0x8:main

/*
 * 停止する
 */
stop:
	/* 画面出力 */
	mov		ax, 0xB800					/* セグメント初期化 */
	mov		fs, ax
	mov		si, 0						/* カウンタ初期化 */
	mov		di, 0
stop_1:
	mov		al, [string_stop + si]		/* 一文字取得 */
	cmp		al, 0						/* ナル文字比較 */
	je		stop_2						/* ナル文字 */
	mov		[fs:0 + di], al				/* 一文字出力 */
	inc		si							/* カウンタ更新 */
	add		di, 2
	jmp		stop_1
	
	/* 停止 */
stop_2:
	hlt
	jmp stop_2


.section .data
/* GDT */
.align 8
gdt:
	.word	0x0000, 0x0000, 0x0000, 0x0000		/* ナルセレクタ */
	.word	0xFFFF, 0x0000, 0x9A00, 0x00CF		/* コードセグメント */
	.word	0xFFFF, 0x0000, 0x9200, 0x00CF		/* データセグメント */

/* GDTR */
gdtrp:
	.word	. - gdt - 1		/* GDTのサイズ - 1 */
	.long	gdt

/* 文字列 */
string_stop:
	.asciz "Mochi Booter stopped."
