/*******************************************************************************
 * booter/protected_mode/pic.c
 *                                                                   2012/10/05
 * Copyright (C) 2012 Mochi
 ******************************************************************************/
#include <ia-32/instructions.h>

/* PIC1 */
#define PIC1_ICW1 0x20
#define PIC1_ICW2 0x21
#define PIC1_ICW3 0x21
#define PIC1_ICW4 0x21
#define PIC1_OCW1 0x21
/* PIC2 */
#define PIC2_ICW1 0xA0
#define PIC2_ICW2 0xA1
#define PIC2_ICW3 0xA1
#define PIC2_ICW4 0xA1
#define PIC2_OCW1 0xA1

/*
 * PICを初期化し、割込みを有効にする
 */
void set_pic(void) {
	/* PIC1 初期化 */
	out_byte(PIC1_ICW1, 0x11);		/* PIC1初期設定 */
	out_byte(PIC1_ICW2, 0x20);		/* 割込みベクタベース設定 */
	out_byte(PIC1_ICW3, 0x04);		/* PIC構成設定 */
	out_byte(PIC1_ICW4, 0x01);		/* モード設定 */
	
	/* PIC2 初期化 */
	out_byte(PIC2_ICW1, 0x11);		/* PIC2初期設定 */
	out_byte(PIC2_ICW2, 0x28);		/* 割込みベクタベース設定 */
	out_byte(PIC2_ICW3, 0x02);		/* PIC構成設定 */
	out_byte(PIC2_ICW4, 0x01);		/* モード設定 */
	
	/* 割込み有効化 */
	out_byte(PIC1_OCW1, 0xFB);
	out_byte(PIC2_OCW1, 0xBF);
}
