//
//  LFMenu.m
//  LetterFix2
//
//  Created by kuri on 10/02/26.
//  Copyright 2010-2020 kuri. All rights reserved.
//

#import "LFMenu.h"

@implementation LFMenu

- (id) initWithApp:(LFApp *)app
{
    self = [super init];
    
    _app       = app;
    
    return self;
}

- (BOOL) inject
{
    NSMenu *newmenu, *appmenu;
    NSMenuItem *item;
    
    @try {
	[self retain];
	
	newmenu = [[NSMenu alloc] initWithTitle:@"LetterFix Plug-in"];
	
	onoff = [self newMenuItem:@"LetterFix を有効にする" action:@selector(onMenuIsActive:) state:[_app isActive] indent:0];
	[newmenu addItem:onoff];
	[newmenu addItem:[self newMenuItem:@"機種依存文字を代替形式に変換" action:@selector(onMenuShouldFixDependents:) state:_app.shouldFixOsDependents indent:1]];
        [newmenu addItem:[self newMenuItem:@"編集開始時に㈪㈫…㈵㈼…を丸数字・ローマ数字と見なす" action:@selector(onMenuShouldFixParenSymbols:) state:_app.shouldFixParenSymbols indent:2]];
        [newmenu addItem:[self newMenuItem:@"㈹㈱㈲は⑫⑭⑰と見なさない" action:@selector(onMenuShouldNotFixSomeParenSymbols:) state:_app.shouldNotFixSomeParenSymbols indent:3]];
	[newmenu addItem:[self newMenuItem:@"ISO 2022-JP に変換できない文字を「〓」に修正" action:@selector(onMenuShouldFixAllLetters:) state:_app.shouldFixAllLetters indent:1]];
	[newmenu addItem:[self newMenuItem:@"修正時に〓に加えて元の文字コードを付加する" action:@selector(onMenuShouldAppendCodeInfo:) state:_app.shouldAppendCodeInfo indent:2]];
        [newmenu addItem:[self newMenuItem:@"ZERO WIDTH SPACEを削除する" action:@selector(onMenuShouldIgnoreZeroWidthSpace:) state:_app.shouldIgnoreZeroWidthSpace indent:2]];
	[newmenu addItem:[self newMenuItem:@"件名をチェックする" action:@selector(onMenuShouldCheckSubject:) state:_app.shouldCheckSubject indent:1]];
	[newmenu addItem:[self newMenuItem:@"保存時にチェックする" action:@selector(onMenuShouldCheckOnSave:) state:_app.shouldCheckOnSave indent:1]];
	[newmenu addItem:[NSMenuItem separatorItem]];
	[newmenu addItem:[self newMenuItem:@"メッセージ編集開始時の動作をリセット" action:@selector(onRestOperationModeOnLoad:) state:NO indent:0]];
	[newmenu addItem:[self newMenuItem:@"LetterFixについて…" action:@selector(showAboutLetterfix:) state:NO indent:0]];
	
	item = [[NSMenuItem alloc] initWithTitle:@"LetterFix Plug-in" action:NULL keyEquivalent:@""];
	[item setSubmenu:newmenu];
	
	appmenu = [[[[NSApplication sharedApplication] mainMenu] itemAtIndex:0] submenu];
	[appmenu insertItem:[NSMenuItem separatorItem] atIndex:1];
	[appmenu insertItem:item atIndex:2];
    }
    @catch (NSException * e) {
	NSLog(@"raise %@", e);
    }
    
    return YES;
}

- (NSMenuItem *)newMenuItem:(NSString *)title action:(SEL)sel state:(BOOL)state indent:(NSInteger)indent
{
    NSMenuItem *item;
    item = [[NSMenuItem alloc] initWithTitle:title action:sel keyEquivalent:@""];
    [item setTarget:self];
    [item setState:state];
    [item setIndentationLevel:indent];
    return item;
}

- (void) onMenuIsActive:(NSMenuItem *)sender
{
    [_app setIsActive:(!sender.state)];
    [sender setState:[_app isActive]];
}

- (void) onMenuShouldFixDependents:(NSMenuItem *)sender
{
    _app.shouldFixOsDependents = !sender.state;
    sender.state = !sender.state;
}

- (void) onMenuShouldFixParenSymbols:(NSMenuItem *)sender
{
    _app.shouldFixParenSymbols = !sender.state;
    sender.state = !sender.state;
}

- (void) onMenuShouldNotFixSomeParenSymbols:(NSMenuItem *)sender
{
    _app.shouldNotFixSomeParenSymbols = !sender.state;
    sender.state = !sender.state;
}

- (void) onMenuShouldFixAllLetters:(NSMenuItem *)sender
{
    _app.shouldFixAllLetters = !sender.state;
    sender.state = !sender.state;
}

- (void) onMenuShouldAppendCodeInfo:(NSMenuItem *)sender
{
    _app.shouldAppendCodeInfo = !sender.state;
    sender.state = !sender.state;
}

- (void) onMenuShouldIgnoreZeroWidthSpace:(NSMenuItem *)sender
{
    _app.shouldIgnoreZeroWidthSpace = !sender.state;
    sender.state = !sender.state;
}

- (void) onRestOperationModeOnLoad:(NSMenuItem *)sender
{
    _app.operationModeOnLoad = 0;
}

- (void) onMenuShouldCheckSubject:(NSMenuItem *)sender
{
    _app.shouldCheckSubject = !sender.state;
    sender.state = !sender.state;
}

- (void) onMenuShouldCheckOnSave:(NSMenuItem *)sender
{
    _app.shouldCheckOnSave = !sender.state;
    sender.state = !sender.state;
}

- (void) showAboutLetterfix:(NSMenuItem *)sender
{
    NSAlert *alert = [[NSAlert alloc] init];
    [alert setMessageText:[NSString stringWithFormat:@"LetterFix plug-in v%s",(LETTERFIX_VERSION)]];
    [alert setInformativeText:@"このプラグインは，メールに含まれる ISO 2022-JP に変換できない文字を置換し，"
     @"ISO 2022-JP を用いてメールを返信・転送可能にするためのものです。"];
    [alert setAlertStyle:NSInformationalAlertStyle];
    [alert runModal];
    [alert release];
}

- (BOOL) validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)anItem
{
    if (!_app.isActive) {
	if (([anItem action] == @selector(onMenuShouldFixDependents:))||
            ([anItem action] == @selector(onMenuShouldFixParenSymbols:))||
            ([anItem action] == @selector(onMenuShouldNotFixSomeParenSymbols:))||
	    ([anItem action] == @selector(onMenuShouldFixAllLetters:))||
            ([anItem action] == @selector(onMenuShouldAppendCodeInfo:))||
            ([anItem action] == @selector(onMenuShouldIgnoreZeroWidthSpace:))||
            ([anItem action] == @selector(onMenuShouldCheckSubject:))||
            ([anItem action] == @selector(onMenuShouldCheckOnSave:)))
	    return NO;
    } else if (!_app.shouldFixOsDependents) {
	if (([anItem action] == @selector(onMenuShouldFixParenSymbols:))||
            ([anItem action] == @selector(onMenuShouldNotFixSomeParenSymbols:)))
	    return NO;
    } else if (!_app.shouldFixAllLetters){
        if (([anItem action] == @selector(onMenuShouldAppendCodeInfo:))||
            ([anItem action] == @selector(onMenuShouldIgnoreZeroWidthSpace:))) {
            return NO;
        }
    } else if (!_app.shouldFixParenSymbols) {
	if ([anItem action] == @selector(onMenuShouldNotFixSomeParenSymbols:))
	    return NO;
    }
    return YES;
}

- (NSMenuItem *)onoffMenuItem
{
    return onoff;
}
@end
