//
//  LFMenu.h
//  LetterFix2
//
//  Created by kuri on 10/02/26.
//  Copyright 2010-2020 kuri. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AppKit/AppKit.h>
#import "LFApp.h"

@interface LFMenu : NSObject {
    LFApp *_app;
    NSMenuItem *onoff;
}

- (id) initWithApp:(id)app;
- (BOOL) inject;
- (void) onMenuIsActive:(NSMenuItem *)sender;
- (void) onMenuShouldFixDependents:(NSMenuItem *)sender;
- (void) onMenuShouldFixParenSymbols:(NSMenuItem *)sender;
- (void) onMenuShouldNotFixSomeParenSymbols:(NSMenuItem *)sender;
- (void) onMenuShouldFixAllLetters:(NSMenuItem *)sender;
- (void) onMenuShouldAppendCodeInfo:(NSMenuItem *)sender;
- (void) onMenuShouldIgnoreZeroWidthSpace:(NSMenuItem *)sender;
- (void) onMenuShouldCheckSubject:(NSMenuItem *)sender;
- (void) onMenuShouldCheckOnSave:(NSMenuItem *)sender;
- (void) onRestOperationModeOnLoad:(NSMenuItem *)sender;
- (void) showAboutLetterfix:(NSMenuItem *)sender;
- (NSMenuItem *)newMenuItem:(NSString *)title action:(SEL)sel state:(BOOL)state indent:(NSInteger)indent;
- (BOOL) validateUserInterfaceItem:(id<NSValidatedUserInterfaceItem>)anItem;
- (NSMenuItem *)onoffMenuItem;
@end
