#ifndef THUMBNAILDELEGATE_H
#define THUMBNAILDELEGATE_H

#include <QStyledItemDelegate>

class ThumbnailDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit ThumbnailDelegate(QObject *parent = 0);

    void    resetScale();
    void    scaleDown();
    void    scaleUp();

private:
    double  m_scaleFactor;

signals:

public slots:

    // QAbstractItemDelegate interface
public:
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;
};

inline void ThumbnailDelegate::resetScale()
{
    m_scaleFactor = 1.0;
}

inline void ThumbnailDelegate::scaleDown()
{
    m_scaleFactor *= 0.8;
}

inline void ThumbnailDelegate::scaleUp()
{
    m_scaleFactor *= 1.25;
}

#endif // THUMBNAILDELEGATE_H
