#ifndef TEXTVIEW_H
#define TEXTVIEW_H

#include <QWidget>
class QScrollArea;

class TextView : public QWidget
{
    Q_OBJECT
public:
    explicit TextView(QScrollArea *parent = 0);

    void    setData(const QByteArray &data);

private:
    struct ViewPosition {
        int lineNum;    // 行番号
        int offset;     // 文字列先頭からのオフセット
        int x;          // X座標
        int y;          // Y座標

        ViewPosition() :
            lineNum(0), offset(0), x(0), y(0)
        {
        }
    };

    QScrollArea*            m_scrollArea;
    QByteArray              m_source;
    QString                 m_data;
    int                     m_charHeight;
    int                     m_charWidth;
    int                     m_tabWidth;
    QVector<ViewPosition>   m_viewPositions;
    int                     m_selectionBegin;
    int                     m_selectionEnd;
    int                     m_selectionInit;

    void    adjust();
    void    convertFrom(const char *code);
    int     cursorPos(const QPoint &pos);
    int     lineNumChars(int lines = -1) const;
    void    resetSelection(int index);
    void    setSelection(int index);

signals:
    void    copyAvailable(bool);
    void    statusChanged(const QString &text);

public slots:
    void    onConvertFromEUC();
    void    onConvertFromJIS();
    void    onConvertFromSJIS();
    void    onConvertFromUTF8();
    void    onConvertFromUTF16();
    void    onConvertFromUTF16BE();
    void    onConvertFromUTF16LE();
    void    onCopy();
    void    onScaleDown();
    void    onScaleUp();
    void    onSelectAll();

    // QWidget interface
public slots:
    void setVisible(bool visible);

protected:
    void mousePressEvent(QMouseEvent *e);
    void mouseDoubleClickEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    void paintEvent(QPaintEvent *e);
    void resizeEvent(QResizeEvent *e);
};

#endif // TEXTVIEW_H
