#ifndef PANEL_H
#define PANEL_H

#include <QWidget>
#include <QModelIndex>
#include <QPointer>
class MainWindow;
class FileReadWorker;
class FolderPanel;
class FolderModel;
class Preferences;

namespace Ui {
class Panel;
}

class Panel : public QWidget
{
    Q_OBJECT

public:
    explicit Panel(QWidget *parent = 0);
    ~Panel();

    FolderPanel*    folderPanel() const;
    void            initialize(MainWindow *w);
    FolderModel*    model() const;
    void            setModel(FolderModel *m);
    void            setViewItem(const QModelIndex &index = QModelIndex());
    void            updateAppearance(const Preferences &prefs);
    QWidget*        visibleView() const;

private:
    Ui::Panel *ui;
    QPointer<FileReadWorker> m_worker;

public slots:
    void    onReady(const QByteArray &data);

signals:
    void    showed(QWidget *w);
};

#endif // PANEL_H
