#ifndef IMAGEVIEW_H
#define IMAGEVIEW_H

#include <QWidget>
class QScrollArea;

class ImageView : public QWidget
{
    Q_OBJECT
public:
    explicit ImageView(QScrollArea *parent = 0);

    void    setData(const QPixmap &pixmap);

private:
    QScrollArea*    m_scrollArea;
    QPixmap         m_pixmap;
    QPixmap         m_scaledPixmap;
    double          m_scaleFactor;
    int             m_rotateDeg;
    QPoint          m_dragStartPos;
    QPoint          m_dragStartScrollPos;

    double  scaleFactor();
    void    resizePixmap();

signals:
    void    statusChanged(const QString &text);

public slots:
    void    onFitToWindow();
    void    onRotate90();
    void    onRotate180();
    void    onScaleDown();
    void    onScaleNormal();
    void    onScaleUp();

    // QWidget interface
public slots:
    void setVisible(bool visible);

protected:
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *e);
    void paintEvent(QPaintEvent *);
    void resizeEvent(QResizeEvent *e);
};

#endif // IMAGEVIEW_H
