#include "filereadworker.h"

#include <QDebug>
#include <QThread>

const int BUFFER_SIZE = 4096;

///////////////////////////////////////////////////////////////////////////////
/// \brief FileReadWorker::FileReadWorker
///
/// コンストラクタ
///
FileReadWorker::FileReadWorker() :
    AbstractWorker(),
    m_file()
{
}

///////////////////////////////////////////////////////////////////////////////
/// \brief FileReadWorker::open
/// \param path ファイルパス
/// \return ファイルオープンに成功した場合はtrueを返します。
///
bool FileReadWorker::open(const QString &path)
{
    m_file.setFileName(path);
    return m_file.open(QIODevice::ReadOnly);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief FileReadWorker::run
///
/// ファイル読込を実行します。
///
void FileReadWorker::run()
{
    if (!m_file.isOpen()) {
        emit finished();
        return;
    }

    emit size(m_file.size());

    QByteArray data;
    while (!m_file.atEnd()) {
        this->thread()->msleep(1);
        if (isAborted()) {
            emit finished(true);
            m_file.close();
            return;
        }

        data.append(m_file.read(BUFFER_SIZE));
        emit progress(data.size());
    }

    emit resultReady(data);
    emit finished();
}
