#ifndef ABSTRACTRENAMEDIALOG_H
#define ABSTRACTRENAMEDIALOG_H

#include "global.h"

#include <QDialog>
#include <QDir>

class AbstractRenameDialog : public QDialog
{
    Q_OBJECT
public:
    explicit AbstractRenameDialog(QWidget *parent = 0) :
        QDialog(parent)
    {
    }

    const StringMap& renameMap() const
    {
        return m_RenameMap;
    }

    void setWorkingDirectory(const QString &path)
    {
        m_dir.setPath(path);
    }

    virtual void setNames(const QFileInfoList &names) = 0;

signals:

public slots:

protected:
    QDir m_dir;
    StringMap m_RenameMap;
};

#endif // ABSTRACTRENAMEDIALOG_H
