/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.render.flatFaceRender;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.data.GraphDataCellListener;
import com.ecm.graphics.render.flatFaceRender.DataChanger;
import com.ecm.graphics.render.flatFaceRender.Plane2d;
import com.ecm.graphics.tools.ColorTable;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.math.BigDecimal;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class ValuePlane
extends TransformGroup
implements GraphDataCellListener {
    private Color3f white = new Color3f(1.0f, 1.0f, 1.0f);
    private Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    private Text3D myText3D = null;
    private float theValue = 0.0f;
    private float oldValue = 0.0f;
    private Plane2d plane2d;
    private Point3f A;
    private Point3f B;
    private Point3f C;
    private Point3f D;
    private int xCoord = 0;
    private int zCoord = 0;
    private float fudgeValue = 0.0f;
    private TransformGroup planeTransformGroup = new TransformGroup();
    private DataChanger vpi;
    private BranchGroup wallBG = null;
    private BranchGroup textBG = null;
    private float translationSave = 0.0f;

    public ValuePlane(Point3f A, Point3f B, Point3f C, Point3f D, float theValue, int xCoord, int zCoord, float fudgeValue, DataChanger vpi) {
        this.A = A;
        this.B = B;
        this.C = C;
        this.D = D;
        this.xCoord = xCoord;
        this.zCoord = zCoord;
        this.fudgeValue = fudgeValue;
        this.vpi = vpi;
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = 0.01;
        double Y2 = 0.0;
        this.theValue = theValue;
        this.plane2d = new Plane2d(A, B, C, D, ColorTable.getColor(theValue), true, xCoord, zCoord, theValue, false);
        float xPosition = A.x;
        float zPosition = (A.z + C.z) / 2.0f;
        float yPosition = A.y;
        this.textBG = this.getTextBG(this.theValue);
        this.planeTransformGroup.setCapability(12);
        this.planeTransformGroup.setCapability(13);
        this.planeTransformGroup.setCapability(17);
        this.planeTransformGroup.setCapability(18);
        this.planeTransformGroup.setCapability(14);
        this.planeTransformGroup.addChild((Node)this.plane2d);
        this.planeTransformGroup.addChild((Node)this.textBG);
        this.planeTransformGroup.addChild((Node)this.getRing());
        this.modifyHeightInternal(theValue);
        this.addChild((Node)this.planeTransformGroup);
    }

    private BranchGroup getTextBG(double textValue) {
        BigDecimal roundfinalPrice = new BigDecimal(textValue).setScale(2, 4);
        Double doublePrice = new Double(roundfinalPrice.doubleValue());
        textValue = doublePrice;
        BranchGroup textBG = new BranchGroup();
        textBG.setCapability(17);
        double X1 = 0.0;
        double Y1 = 0.0;
        double X2 = 0.01;
        double Y2 = 0.0;
        Line2D.Double extrusionShape = new Line2D.Double(X1, Y1, X2, Y2);
        FontExtrusion myExtrude = new FontExtrusion((Shape)extrusionShape);
        Appearance app = new Appearance();
        ColoringAttributes ca = new ColoringAttributes(this.black, 2);
        app.setColoringAttributes(ca);
        Font myFont = new Font("Arial", 1, 1);
        Font3D myFont3D = new Font3D(myFont, myExtrude);
        this.myText3D = new Text3D(myFont3D, String.valueOf(textValue));
        Shape3D myShape3D = new Shape3D((Geometry)this.myText3D, app);
        float xPosition = this.A.x;
        float zPosition = (this.A.z + this.C.z) / 2.0f;
        float yPosition = this.A.y;
        TransformGroup myshapeTransformGroup = new TransformGroup();
        Transform3D myTransform3D = new Transform3D();
        myTransform3D.rotX(-1.5707963267948966);
        myTransform3D.setTranslation(new Vector3f(xPosition, 0.02f, zPosition));
        myTransform3D.setScale(0.35);
        myshapeTransformGroup.setTransform(myTransform3D);
        myshapeTransformGroup.addChild((Node)myShape3D);
        textBG.addChild((Node)myshapeTransformGroup);
        return textBG;
    }

    private TransformGroup getRing() {
        Vector<Shape3D> myShapes = new Vector<Shape3D>();
        Appearance app = new Appearance();
        LineAttributes la = new LineAttributes();
        la.setLineWidth(2.0f);
        app.setLineAttributes(la);
        ColoringAttributes ca = new ColoringAttributes(this.black, 2);
        app.setColoringAttributes(ca);
        Point3f[] lineStart = new Point3f[4];
        Point3f[] lineEnded = new Point3f[4];
        lineStart[0] = new Point3f(this.A);
        lineEnded[0] = new Point3f(this.B);
        lineStart[1] = new Point3f(this.B);
        lineEnded[1] = new Point3f(this.C);
        lineStart[2] = new Point3f(this.C);
        lineEnded[2] = new Point3f(this.D);
        lineStart[3] = new Point3f(this.D);
        lineEnded[3] = new Point3f(this.A);
        int i = 0;
        while (i < 4) {
            Point3f[] plaPts = new Point3f[]{lineStart[i], lineEnded[i]};
            LineArray pla = new LineArray(2, 1);
            pla.setCoordinates(0, plaPts);
            Shape3D plShape = new Shape3D((Geometry)pla, app);
            myShapes.add(plShape);
            ++i;
        }
        TransformGroup axesTransformGroup = new TransformGroup();
        for (Shape3D myshape3d : myShapes) {
            axesTransformGroup.addChild((Node)myshape3d);
        }
        return axesTransformGroup;
    }

    public Point3f getA() {
        return this.A;
    }

    public Point3f getB() {
        return this.B;
    }

    public Point3f getC() {
        return this.C;
    }

    public Point3f getD() {
        return this.D;
    }

    public float getTheValue() {
        return this.theValue;
    }

    public Plane2d getPlane2d() {
        return this.plane2d;
    }

    public void modifyHeight(float value, int count) {
        float tempValue = value;
        this.oldValue = this.theValue;
        this.theValue = value;
        this.planeTransformGroup.removeChild((Node)this.textBG);
        this.textBG = this.getTextBG(value);
        Transform3D planeTransform = new Transform3D();
        this.translationSave = this.theValue / (float)GraphData.getMaxY() * this.fudgeValue;
        planeTransform.setTranslation(new Vector3f(0.0f, this.translationSave, 0.0f));
        this.planeTransformGroup.setTransform(planeTransform);
        this.planeTransformGroup.addChild((Node)this.textBG);
        this.vpi.modifyHeight(this.xCoord, this.zCoord, this.theValue, count);
    }

    public void undoHeightChange(int totalCount) {
        this.modifyHeight(this.oldValue, totalCount);
    }

    private void modifyHeightInternal(float value) {
        this.oldValue = this.theValue;
        this.theValue = value;
        this.translationSave = this.theValue / (float)GraphData.getMaxY() * this.fudgeValue;
        Transform3D planeTransform = new Transform3D();
        planeTransform.setTranslation(new Vector3f(0.0f, this.translationSave, 0.0f));
        this.planeTransformGroup.setTransform(planeTransform);
    }

    public float getModifiedYValue() {
        return this.theValue / (float)GraphData.getMaxY() * this.fudgeValue;
    }

    public float getOldValue() {
        return this.oldValue;
    }

    public void modifyHeight(int x, int z, float value, int count) {
    }

    public BranchGroup getWallBG() {
        return this.wallBG;
    }

    public void setWallBG(BranchGroup wallBG) {
        this.wallBG = wallBG;
    }

    public void graphDataChanged(float value, int count, int type) {
        this.modifyHeight(value, count);
        this.plane2d.theValue = value;
    }

    public void selectStateChanged(boolean value) {
        this.plane2d.setSelected(value);
    }
}

