/*
 * Decompiled with CFR 0.152.
 */
package com.ecm.graphics.render.flatFaceRender;

import com.ecm.graphics.data.GraphData;
import com.ecm.graphics.render.flatFaceRender.DataChanger;
import com.ecm.graphics.render.flatFaceRender.Plane2d;
import com.ecm.graphics.render.flatFaceRender.ValuePlane;
import com.ecm.graphics.tools.ColorTable;
import java.util.LinkedHashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

public class Graph3dFlatFaceRender
extends TransformGroup
implements DataChanger {
    private int xWidth;
    private int zDepth;
    private LinkedHashMap tempFaceHash = new LinkedHashMap();
    private ValuePlane[][] faces;
    private float fudgedScaleYMax;
    private TransformGroup wallTG;

    public Graph3dFlatFaceRender(float fudgedScaleYMax) {
        this.xWidth = GraphData.getXWidth();
        this.zDepth = GraphData.getZDepth();
        this.fudgedScaleYMax = fudgedScaleYMax;
        this.setCapability(18);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        this.faces = this.getFaces();
        this.wallTG = this.buildWalls();
        this.addChild((Node)this.wallTG);
        this.addChild((Node)this.buildFaces());
    }

    private TransformGroup buildFaces() {
        TransformGroup facesTransformGroup = new TransformGroup();
        int i = 0;
        while (i < this.zDepth) {
            int j = 0;
            while (j < this.xWidth) {
                facesTransformGroup.addChild((Node)this.faces[j][i]);
                ++j;
            }
            ++i;
        }
        return facesTransformGroup;
    }

    private ValuePlane getValueFace(int x, int z) {
        float thickness = 0.01f;
        Point3f A = new Point3f((float)x + thickness, 0.0f, (float)(-z) - thickness);
        Point3f B = new Point3f((float)(x + 1) - thickness, 0.0f, (float)(-z) - thickness);
        Point3f C = new Point3f((float)(x + 1) - thickness, 0.0f, -((float)(z + 1) - thickness));
        Point3f D = new Point3f((float)x + thickness, 0.0f, -((float)(z + 1) - thickness));
        ValuePlane plane = new ValuePlane(A, B, C, D, GraphData.getCellValue(x, z), x, z, this.fudgedScaleYMax, this);
        return plane;
    }

    private ValuePlane[][] getFaces() {
        ValuePlane[][] tempFaces = new ValuePlane[this.xWidth][this.zDepth];
        int i = 0;
        while (i < this.zDepth) {
            int j = 0;
            while (j < this.xWidth) {
                tempFaces[j][i] = this.getValueFace(j, i);
                GraphData.addGraphDataCellListener(j, i, tempFaces[j][i]);
                ++j;
            }
            ++i;
        }
        return tempFaces;
    }

    private TransformGroup buildWalls() {
        TransformGroup wallTG = new TransformGroup();
        wallTG.setCapability(12);
        wallTG.setCapability(13);
        wallTG.setCapability(14);
        int x = 0;
        while (x < this.xWidth) {
            int z = 0;
            while (z < this.zDepth) {
                ValuePlane plane1 = this.faces[x][z];
                BranchGroup tempBG = this.buildWallBG(x, z, plane1);
                plane1.setWallBG(tempBG);
                wallTG.addChild((Node)tempBG);
                ++z;
            }
            ++x;
        }
        return wallTG;
    }

    public void modifyHeight(int x, int z, float value, int totalCount) {
        this.tempFaceHash.put(String.valueOf(x) + "," + z, new MyPoint(x, z));
        if (this.tempFaceHash.size() == totalCount) {
            BranchGroup newWallBG;
            int bgIndex;
            MyPoint tempPoint;
            int j;
            int i = 0;
            while (i < this.zDepth) {
                j = 0;
                while (j < this.xWidth) {
                    ValuePlane vp;
                    tempPoint = (MyPoint)this.tempFaceHash.get(String.valueOf(j) + "," + i);
                    if (tempPoint != null && (vp = this.faces[j][i]).getWallBG() != null) {
                        bgIndex = this.wallTG.indexOfChild((Node)vp.getWallBG());
                        newWallBG = this.buildWallBG(tempPoint.x, tempPoint.z, vp);
                        vp.setWallBG(newWallBG);
                        this.wallTG.setChild((Node)newWallBG, bgIndex);
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.zDepth) {
                j = 0;
                while (j < this.xWidth) {
                    ValuePlane vpb;
                    tempPoint = (MyPoint)this.tempFaceHash.get(String.valueOf(j) + "," + i);
                    if (tempPoint == null && this.hasSelectedNeighbor(j, i) && (vpb = this.faces[j][i]).getWallBG() != null) {
                        bgIndex = this.wallTG.indexOfChild((Node)vpb.getWallBG());
                        newWallBG = this.buildWallBG(j, i, vpb);
                        vpb.setWallBG(newWallBG);
                        this.wallTG.setChild((Node)newWallBG, bgIndex);
                    }
                    ++j;
                }
                ++i;
            }
            this.tempFaceHash.clear();
        }
    }

    private boolean hasSelectedNeighbor(int x, int z) {
        Object temp;
        if (x > 0 && (temp = this.tempFaceHash.get(String.valueOf(x - 1) + "," + z)) != null) {
            return true;
        }
        if (x < this.xWidth && (temp = this.tempFaceHash.get(String.valueOf(x + 1) + "," + z)) != null) {
            return true;
        }
        if (z < this.zDepth && (temp = this.tempFaceHash.get(String.valueOf(x) + "," + (z + 1))) != null) {
            return true;
        }
        return z > 0 && (temp = this.tempFaceHash.get(String.valueOf(x) + "," + (z - 1))) != null;
    }

    private BranchGroup buildWallBG(int x, int z, ValuePlane plane1) {
        Plane2d plane;
        ValuePlane plane2;
        BranchGroup tempBG = new BranchGroup();
        tempBG.setCapability(17);
        if (x != 0) {
            plane2 = this.faces[x - 1][z];
            plane = this.buildSideWall(plane1, plane2);
            tempBG.addChild((Node)plane);
        }
        if (z != 0) {
            plane2 = this.faces[x][z - 1];
            plane = this.buildBottomWall(plane1, plane2);
            tempBG.addChild((Node)plane);
        }
        return tempBG;
    }

    private Plane2d buildBottomWall(ValuePlane plane1, ValuePlane plane2) {
        float value1Temp = plane1.getModifiedYValue();
        float value2Temp = plane2.getModifiedYValue();
        Point3f A = plane1.getA();
        Point3f B = plane1.getB();
        Point3f C = plane2.getC();
        Point3f D = plane2.getD();
        float[] tempA = new float[3];
        A.get(tempA);
        tempA[1] = value1Temp;
        A.set(tempA);
        float[] tempB = new float[3];
        B.get(tempB);
        tempB[1] = value1Temp;
        B.set(tempB);
        float[] tempC = new float[3];
        C.get(tempC);
        tempC[1] = value2Temp;
        C.set(tempC);
        float[] tempD = new float[3];
        D.get(tempD);
        tempD[1] = value2Temp;
        D.set(tempD);
        float value1 = plane1.getTheValue();
        float value2 = plane2.getTheValue();
        float aveValue = (value1 + value2) / 2.0f;
        Color3f theColor = ColorTable.getColor(aveValue);
        Plane2d plane = new Plane2d(A, B, C, D, theColor, false, 0, 0, 0.0f, true);
        return plane;
    }

    private Plane2d buildSideWall(ValuePlane plane1, ValuePlane plane2) {
        float value1Temp = plane1.getModifiedYValue();
        float value2Temp = plane2.getModifiedYValue();
        Point3f A = plane1.getD();
        Point3f B = plane1.getA();
        Point3f C = plane2.getB();
        Point3f D = plane2.getC();
        float[] tempA = new float[3];
        A.get(tempA);
        tempA[1] = value1Temp;
        A.set(tempA);
        float[] tempB = new float[3];
        B.get(tempB);
        tempB[1] = value1Temp;
        B.set(tempB);
        float[] tempC = new float[3];
        C.get(tempC);
        tempC[1] = value2Temp;
        C.set(tempC);
        float[] tempD = new float[3];
        D.get(tempD);
        tempD[1] = value2Temp;
        D.set(tempD);
        float value1 = plane1.getTheValue();
        float value2 = plane2.getTheValue();
        float aveValue = (value1 + value2) / 2.0f;
        Color3f theColor = ColorTable.getColor(aveValue);
        Plane2d plane = new Plane2d(A, B, C, D, theColor, false, 0, 0, 0.0f, true);
        return plane;
    }

    private class MyPoint {
        public int x;
        public int z;

        public MyPoint(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean areNeighbors(MyPoint a, MyPoint b) {
            if (a.x == b.x && Math.abs(a.z - b.z) == 1) {
                return true;
            }
            return a.z == b.z && Math.abs(a.x - b.x) == 1;
        }
    }
}

