/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigInfo;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.VirtualUniverse;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;

class NativeConfigTemplate3D {
    private static final boolean debug = false;
    static final int RED_SIZE = 0;
    static final int GREEN_SIZE = 1;
    static final int BLUE_SIZE = 2;
    static final int ALPHA_SIZE = 3;
    static final int ACCUM_BUFFER = 4;
    static final int DEPTH_SIZE = 5;
    static final int DOUBLEBUFFER = 6;
    static final int STEREO = 7;
    static final int ANTIALIASING = 8;
    static final int STENCIL_SIZE = 9;
    static final int NUM_ITEMS = 10;

    NativeConfigTemplate3D() {
    }

    native int chooseOglVisual(long var1, int var3, int[] var4, long[] var5);

    static native void freeFBConfig(long var0);

    native boolean isStereoAvailable(long var1, int var3, int var4);

    native boolean isDoubleBufferAvailable(long var1, int var3, int var4);

    native boolean isSceneAntialiasingAccumAvailable(long var1, int var3, int var4);

    native boolean isSceneAntialiasingMultisampleAvailable(long var1, int var3, int var4);

    native int getStencilSize(long var1, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfigurationArray[0]).getDevice();
        if (!NativeScreenInfo.isGLX13()) {
            return null;
        }
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        Rectangle rectangle = graphicsConfigurationArray[0].getBounds();
        if (!(rectangle.x == 0 && rectangle.y == 0 || VirtualUniverse.mc.xineramaDisabled)) {
            n = 0;
        }
        int[] nArray = new int[10];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        nArray[9] = graphicsConfigTemplate3D.getStencilSize();
        long[] lArray = new long[1];
        int n2 = this.chooseOglVisual(l, n, nArray, lArray);
        if (n2 == 0 || lArray[0] == 0L) {
            return null;
        }
        X11GraphicsConfig x11GraphicsConfig = null;
        for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
            if (((X11GraphicsConfig)graphicsConfigurationArray[i]).getVisual() != n2) continue;
            x11GraphicsConfig = (X11GraphicsConfig)graphicsConfigurationArray[i];
            break;
        }
        if (x11GraphicsConfig == null) {
            return null;
        }
        X11GraphicsConfig x11GraphicsConfig2 = X11GraphicsConfig.getConfig(x11GraphicsDevice, x11GraphicsConfig.getVisual(), x11GraphicsConfig.getDepth(), x11GraphicsConfig.getColormap(), false);
        Hashtable<GraphicsConfiguration, GraphicsConfigInfo> hashtable = Canvas3D.graphicsConfigTable;
        synchronized (hashtable) {
            if (Canvas3D.graphicsConfigTable.get(x11GraphicsConfig2) == null) {
                GraphicsConfigInfo graphicsConfigInfo = new GraphicsConfigInfo(graphicsConfigTemplate3D);
                graphicsConfigInfo.setPrivateData(new Long(lArray[0]));
                Canvas3D.graphicsConfigTable.put(x11GraphicsConfig2, graphicsConfigInfo);
            } else {
                NativeConfigTemplate3D.freeFBConfig(lArray[0]);
            }
        }
        return x11GraphicsConfig2;
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        if (!NativeScreenInfo.isGLX13()) {
            return false;
        }
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        int[] nArray = new int[10];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        nArray[9] = graphicsConfigTemplate3D.getStencilSize();
        long[] lArray = new long[1];
        int n2 = this.chooseOglVisual(l, n, nArray, lArray);
        return n2 != 0 && lArray[0] != 0L;
    }

    boolean hasStereo(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        int n2 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isStereoAvailable(l, n, n2);
    }

    int getStencilSize(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        int n2 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.getStencilSize(l, n, n2);
    }

    boolean hasDoubleBuffer(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        int n2 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isDoubleBufferAvailable(l, n, n2);
    }

    boolean hasSceneAntialiasingAccum(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        int n2 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isSceneAntialiasingAccumAvailable(l, n, n2);
    }

    boolean hasSceneAntialiasingMultisample(Canvas3D canvas3D) {
        GraphicsConfiguration graphicsConfiguration = canvas3D.graphicsConfiguration;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)((X11GraphicsConfig)graphicsConfiguration).getDevice();
        long l = NativeScreenInfo.getDisplay();
        int n = NativeScreenInfo.getScreen(x11GraphicsDevice);
        int n2 = ((X11GraphicsConfig)graphicsConfiguration).getVisual();
        return this.isSceneAntialiasingMultisampleAvailable(l, n, n2);
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

