/*
 * Decompiled with CFR 0.152.
 */
package com.jinvoke;

import com.jinvoke.Callback;
import com.jinvoke.CallingConvention;
import com.jinvoke.Charset;
import com.jinvoke.NativeImport;
import com.jinvoke.NativeStruct;
import com.jinvoke.engine.MethodInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;

public class JInvoke {
    private static boolean libloaded = false;

    private JInvoke() {
    }

    public static void initialize() {
        if (!libloaded) {
            JInvoke.loadLib();
            JInvoke.init();
            libloaded = true;
        }
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        String classname = ste[1].getClassName();
        try {
            Method[] methods;
            Class<?> clazz = Class.forName(classname);
            NativeImport nativeannoclass = clazz.getAnnotation(NativeImport.class);
            String library = "";
            CallingConvention cc = CallingConvention.STDCALL;
            Charset charset = Charset.UNICODE;
            boolean isAnnotated = false;
            String globallib = null;
            if (nativeannoclass != null) {
                globallib = library = nativeannoclass.library();
                cc = nativeannoclass.convention();
                charset = nativeannoclass.charset();
                isAnnotated = true;
            }
            Method[] methodArray = methods = clazz.getDeclaredMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                Method method = methodArray[n];
                if ((method.getModifiers() & 0x100) != 0) {
                    NativeImport nativeanno = method.getAnnotation(NativeImport.class);
                    String methodname = method.getName();
                    MethodInfo mi = JInvoke.getMethodInfo(method);
                    String function = null;
                    if (nativeanno != null) {
                        library = nativeanno.library();
                        function = nativeanno.function();
                        cc = nativeanno.convention();
                        charset = nativeanno.charset();
                        isAnnotated = true;
                    }
                    if (library == null || library.length() == 0) {
                        String string = library = globallib != null ? globallib : clazz.getSimpleName();
                    }
                    if (function == null || function.length() == 0) {
                        function = method.getName();
                    }
                    if (charset == Charset.AUTO) {
                        charset = Charset.UNICODE;
                    }
                    JInvoke.InitMethod(clazz, methodname, mi.signature, library, function, cc.getIntCode(), charset.getIntCode(), mi.jargsize, mi.nargsize, mi.argtypes);
                }
                ++n;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static synchronized native void InitMethod(Class var0, String var1, String var2, String var3, String var4, int var5, int var6, int var7, int var8, int[] var9);

    static MethodInfo getMethodInfo(Method method) {
        StringBuffer signature = new StringBuffer();
        int jargsize = 8;
        int nargsize = 0;
        Class<?>[] paramclass = method.getParameterTypes();
        int numparams = paramclass.length;
        int[] argtype = new int[numparams + 1];
        signature.append("(");
        int i = 0;
        while (i < numparams) {
            if (paramclass[i] == Boolean.TYPE) {
                signature.append("Z");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 1;
            } else if (paramclass[i] == Boolean.class) {
                signature.append("Ljava/lang/Boolean;");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 2;
            } else if (paramclass[i] == Byte.TYPE) {
                signature.append("B");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 3;
            } else if (paramclass[i] == Character.TYPE) {
                signature.append("C");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4;
            } else if (paramclass[i] == Short.TYPE) {
                signature.append("S");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 5;
            } else if (paramclass[i] == Integer.TYPE) {
                signature.append("I");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 6;
            } else if (paramclass[i] == Long.TYPE) {
                signature.append("J");
                jargsize += 8;
                nargsize += 8;
                argtype[i] = 7;
            } else if (paramclass[i] == Float.TYPE) {
                signature.append("F");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 9;
            } else if (paramclass[i] == Double.TYPE) {
                signature.append("D");
                jargsize += 8;
                nargsize += 8;
                argtype[i] = 10;
            } else if (paramclass[i] == boolean[].class) {
                signature.append("[Z");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4097;
            } else if (paramclass[i] == Boolean[].class) {
                signature.append("[Ljava/lang/Boolean;");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4098;
            } else if (paramclass[i] == byte[].class) {
                signature.append("[B");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4099;
            } else if (paramclass[i] == char[].class) {
                signature.append("[C");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4100;
            } else if (paramclass[i] == short[].class) {
                signature.append("[S");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4101;
            } else if (paramclass[i] == int[].class) {
                signature.append("[I");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4102;
            } else if (paramclass[i] == long[].class) {
                signature.append("[J");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4103;
            } else if (paramclass[i] == float[].class) {
                signature.append("[F");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4105;
            } else if (paramclass[i] == double[].class) {
                signature.append("[D");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4106;
            } else if (paramclass[i].isArray() && paramclass[i].getComponentType() != null && paramclass[i].getComponentType().getAnnotation(NativeStruct.class) != null) {
                signature.append("[L");
                signature.append(paramclass[i].getComponentType().getName().replace('.', '/'));
                signature.append(";");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 4110;
            } else if (paramclass[i] == String.class) {
                signature.append("Ljava/lang/String;");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 11;
            } else if (paramclass[i] == StringBuffer.class) {
                signature.append("Ljava/lang/StringBuffer;");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 12;
            } else if (paramclass[i] == StringBuilder.class) {
                signature.append("Ljava/lang/StringBuilder;");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 13;
            } else if (paramclass[i].getAnnotation(NativeStruct.class) != null) {
                signature.append("L");
                signature.append(paramclass[i].getName().replace('.', '/'));
                signature.append(";");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 14;
            } else if (paramclass[i] == Callback.class) {
                signature.append("Lcom/jinvoke/Callback;");
                jargsize += 4;
                nargsize += 4;
                argtype[i] = 16;
            } else {
                throw new RuntimeException("Method " + method + " has parameters of unsupported type: " + paramclass[i].getName());
            }
            ++i;
        }
        signature.append(")");
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            signature.append("V");
            argtype[numparams] = 0;
        } else if (returnType == Boolean.TYPE) {
            signature.append("Z");
            argtype[numparams] = 1;
        } else if (returnType.getClass() == Boolean.class) {
            signature.append("Ljava/lang/Boolean;");
            argtype[numparams] = 2;
        } else if (returnType == Byte.TYPE) {
            signature.append("B");
            argtype[numparams] = 3;
        } else if (returnType == Character.TYPE) {
            signature.append("C");
            argtype[numparams] = 4;
        } else if (returnType == Short.TYPE) {
            signature.append("S");
            argtype[numparams] = 5;
        } else if (returnType == Integer.TYPE) {
            signature.append("I");
            argtype[numparams] = 6;
        } else if (returnType == Long.TYPE) {
            signature.append("J");
            argtype[numparams] = 7;
        } else if (returnType == Float.TYPE) {
            signature.append("F");
            argtype[numparams] = 9;
        } else if (returnType == Double.TYPE) {
            signature.append("D");
            argtype[numparams] = 10;
        } else if (returnType == boolean[].class) {
            signature.append("[Z");
            argtype[numparams] = 4097;
        } else if (returnType == Boolean[].class) {
            signature.append("[Ljava/lang/Boolean;");
        } else if (returnType == byte[].class) {
            signature.append("[B");
            argtype[numparams] = 4099;
        } else if (returnType == char[].class) {
            signature.append("[C");
            argtype[numparams] = 4100;
        } else if (returnType == short[].class) {
            signature.append("[S");
            argtype[numparams] = 4101;
        } else if (returnType == int[].class) {
            signature.append("[I");
            argtype[numparams] = 4102;
        } else if (returnType == long[].class) {
            signature.append("[J");
            argtype[numparams] = 4103;
        } else if (returnType == float[].class) {
            signature.append("[F");
            argtype[numparams] = 4105;
        } else if (returnType == double[].class) {
            signature.append("[D");
            argtype[numparams] = 4106;
        } else if (returnType == String.class) {
            signature.append("Ljava/lang/String;");
            argtype[numparams] = 11;
        } else if (returnType.getAnnotation(NativeStruct.class) != null) {
            signature.append("L");
            signature.append(returnType.getName().replace('.', '/'));
            signature.append(";");
            argtype[numparams] = 14;
        } else {
            throw new RuntimeException("Method " + method + " has unsupported return type: " + returnType.getName());
        }
        return new MethodInfo(signature.toString(), jargsize, nargsize, argtype);
    }

    private static native void init();

    static synchronized void loadNativeLib() {
        if (!libloaded) {
            JInvoke.loadLib();
            JInvoke.init();
            libloaded = true;
        }
    }

    private static synchronized void loadLib() {
        String libname = "jinvoke";
        String sunAppletLauncher = System.getProperty("sun.jnlp.applet.launcher");
        boolean usingJNLPAppletLauncher = Boolean.valueOf(sunAppletLauncher);
        boolean loaded = false;
        if (usingJNLPAppletLauncher) {
            try {
                Class<?> jnlpAppletLauncherClass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                Method jnlpLoadLibraryMethod = jnlpAppletLauncherClass.getDeclaredMethod("loadLibrary", String.class);
                jnlpLoadLibraryMethod.invoke(null, libname);
                loaded = true;
            }
            catch (ClassNotFoundException jnlpAppletLauncherClass) {
            }
            catch (Exception jnlpAppletLauncherClass) {
                // empty catch block
            }
        }
        if (!loaded) {
            try {
                System.loadLibrary(libname);
            }
            catch (Throwable t) {
                File jarFile = null;
                String dllpath = null;
                try {
                    jarFile = new File(JInvoke.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    dllpath = String.valueOf(jarFile.getParent()) + File.separator + System.mapLibraryName(libname);
                }
                catch (URISyntaxException urise) {
                    String jarFileLoc = JInvoke.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    jarFileLoc = jarFileLoc.substring(1, jarFileLoc.lastIndexOf(47));
                    dllpath = String.valueOf(jarFileLoc) + File.separator + System.mapLibraryName(libname);
                }
                try {
                    System.load(dllpath);
                }
                catch (Throwable tt) {
                    JInvoke.extractNativeLib(dllpath);
                    System.load(dllpath);
                }
            }
        }
    }

    private static void extractNativeLib(String dllpath) {
        try {
            int c;
            String osname = System.getProperty("os.name");
            String osarch = System.getProperty("os.arch");
            String jinvokelib = "/native/" + System.mapLibraryName("jinvoke");
            if (osname.equals("SunOS")) {
                if (osarch.equals("x86")) {
                    jinvokelib = "/native/" + osname + "/" + osarch + "/" + System.mapLibraryName("jinvoke");
                } else if (osarch.equals("sparc")) {
                    jinvokelib = "/native/" + osname + "/" + osarch + "/" + System.mapLibraryName("jinvoke");
                } else {
                    System.out.println("SunOS on " + osarch + " architecture is currently not supported by J/Invoke. Contact support@jinvoke.com to request support.");
                }
            }
            InputStream is = JInvoke.class.getResourceAsStream(jinvokelib);
            BufferedInputStream bis = new BufferedInputStream(is);
            File libfile = new File(dllpath);
            libfile.createNewFile();
            FileOutputStream fos = new FileOutputStream(libfile);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            while ((c = bis.read()) != -1) {
                bos.write(c);
            }
            bos.close();
            bis.close();
            is.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

